/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.displaymodel;

import java.io.IOException;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayModel;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.displaymodel.FlowContext;
import org.jfree.layouting.normalizer.displaymodel.ModelBuilder;
import org.jfree.layouting.normalizer.generator.ContentGenerator;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.IntList;
import org.jfree.util.FastStack;

public class FastDisplayModelBuilder
implements ModelBuilder {
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_INLINE = 2;
    public static final int TYPE_MARKER = 3;
    public static final int TYPE_RUBY = 4;
    public static final int TYPE_TABLE = 5;
    public static final int TYPE_TABLE_CELL = 6;
    public static final int TYPE_TABLE_ROW = 7;
    public static final int TYPE_TABLE_SECTION = 8;
    public static final int TYPE_TABLE_COLGROUP = 9;
    public static final int TYPE_TABLE_COL = 10;
    public static final int TYPE_TABLE_CAPTION = 11;
    public static final int TYPE_IGNORED = 12;
    public static final int TYPE_PARAGRAPH = 13;
    public static final int TYPE_FLOW = 14;
    public static final int FLAG_AUTOGENERATED = 0x1000000;
    public static final int MODEL_BLOCK_INSIDE = 1;
    public static final int MODEL_INLINE_INSIDE = 2;
    public static final int MODEL_TABLE = 3;
    public static final int MODEL_TABLE_SECTION = 4;
    public static final int MODEL_TABLE_ROW = 5;
    public static final int MODEL_TABLE_COLGROUP = 6;
    public static final int MODEL_TABLE_COL = 7;
    private LayoutProcess layoutProcess;
    private FastStack flowContexts;
    private ContentGenerator contentGenerator;
    private int suspendCounter;

    public FastDisplayModelBuilder() {
    }

    public FastDisplayModelBuilder(ContentGenerator contentGenerator, LayoutProcess layoutProcess) {
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        if (contentGenerator == null) {
            throw new NullPointerException();
        }
        this.contentGenerator = contentGenerator;
        this.layoutProcess = layoutProcess;
        this.flowContexts = new FastStack();
    }

    public void startDocument(PageContext pageContext) throws NormalizationException {
        this.contentGenerator.startedDocument(pageContext);
    }

    public void startElement(LayoutContext layoutContext) throws NormalizationException, IOException {
        CSSValue displayRole;
        if (this.flowContexts.isEmpty()) {
            FlowContext fc = new FlowContext();
            this.flowContexts.push((Object)fc);
            fc.addElement(1, 0x100000E, layoutContext);
            this.contentGenerator.startedFlow(layoutContext);
        }
        if ((displayRole = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE)) == DisplayRole.NONE || this.suspendCounter > 0) {
            ++this.suspendCounter;
            this.contentGenerator.startedPassThrough(layoutContext);
            return;
        }
        if (displayRole == DisplayRole.TABLE_CAPTION) {
            this.addTableCaption(layoutContext);
            return;
        }
        if (displayRole == DisplayRole.TABLE_COLUMN) {
            this.addTableColumn(layoutContext);
            return;
        }
        if (displayRole == DisplayRole.TABLE_COLUMN_GROUP) {
            this.addTableColumnGroup(layoutContext);
            return;
        }
        if (displayRole == DisplayRole.TABLE_FOOTER_GROUP || displayRole == DisplayRole.TABLE_HEADER_GROUP || displayRole == DisplayRole.TABLE_ROW_GROUP) {
            this.addTableSection(layoutContext);
            return;
        }
        if (displayRole == DisplayRole.TABLE_ROW) {
            this.addTableRow(layoutContext);
            return;
        }
        if (displayRole == DisplayRole.TABLE_CELL) {
            this.addTableCell(layoutContext);
            return;
        }
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        int currentDisplayModel = fc.getActiveDisplayModel();
        switch (currentDisplayModel) {
            case 1: {
                this.addToBlockLevelBox(layoutContext);
                return;
            }
            case 2: {
                this.addToInlineLevelBox(layoutContext);
                return;
            }
            case 3: {
                this.addToTableLevelBox(layoutContext);
                return;
            }
            case 4: {
                StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
                ContextId id = new ContextId(2, -1L, 0L);
                LayoutContext rowContext = styleResolver.createAnonymousContext(id, layoutContext);
                fc.addElement(5, 0x1000007, rowContext);
                this.contentGenerator.startedTableRow(rowContext);
                LayoutContext cellContext = styleResolver.createAnonymousContext(id, rowContext);
                fc.addElement(1, 0x1000006, cellContext);
                this.contentGenerator.startedTableCell(cellContext);
                this.addToBlockLevelBox(layoutContext);
                return;
            }
            case 5: {
                StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
                ContextId id = new ContextId(2, -1L, 0L);
                LayoutContext cellContext = styleResolver.createAnonymousContext(id, layoutContext);
                fc.addElement(1, 0x1000006, cellContext);
                this.contentGenerator.startedTableCell(cellContext);
                this.addToBlockLevelBox(layoutContext);
                return;
            }
            case 6: 
            case 7: {
                ++this.suspendCounter;
                this.contentGenerator.startedPassThrough(layoutContext);
                return;
            }
        }
        throw new NormalizationException("Unexpected type: " + currentDisplayModel + " for display-role " + displayRole);
    }

    private void addTableCaption(LayoutContext context) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        int currentDisplayModel = fc.getCurrentDisplayModel();
        if (currentDisplayModel != 3) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId id = new ContextId(2, -1L, 0L);
            LayoutContext tableContext = styleResolver.createAnonymousContext(id, context);
            fc.addElement(3, 0x1000005, tableContext);
            this.contentGenerator.startedTable(tableContext);
        }
        fc.addElement(1, 11, context);
        this.contentGenerator.startedTableCaption(context);
    }

    private void addTableColumnGroup(LayoutContext context) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        int currentDisplayModel = fc.getCurrentDisplayModel();
        if (currentDisplayModel != 3) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId id = new ContextId(2, -1L, 0L);
            LayoutContext tableContext = styleResolver.createAnonymousContext(id, context);
            fc.addElement(3, 0x1000005, tableContext);
            this.contentGenerator.startedTable(tableContext);
        }
        fc.addElement(6, 9, context);
        this.contentGenerator.startedTableColumnGroup(context);
    }

    private void addTableColumn(LayoutContext context) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        int currentDisplayModel = fc.getCurrentDisplayModel();
        if (currentDisplayModel != 3 && currentDisplayModel != 6) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId id = new ContextId(2, -1L, 0L);
            this.suspendNonBlockElements();
            LayoutContext tableContext = styleResolver.createAnonymousContext(id, context);
            fc.addElement(3, 0x1000005, tableContext);
            this.contentGenerator.startedTable(tableContext);
        }
        fc.addElement(7, 10, context);
        this.contentGenerator.startedTableColumn(context);
    }

    private void addTableSection(LayoutContext context) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        int currentDisplayModel = fc.getCurrentDisplayModel();
        if (currentDisplayModel != 3) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId id = new ContextId(2, -1L, 0L);
            this.suspendNonBlockElements();
            LayoutContext tableContext = styleResolver.createAnonymousContext(id, context);
            fc.addElement(3, 0x1000005, tableContext);
            this.contentGenerator.startedTable(tableContext);
        }
        fc.addElement(4, 8, context);
        this.contentGenerator.startedTableSection(context);
    }

    private void addTableRow(LayoutContext context) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        int currentDisplayModel = fc.getCurrentDisplayModel();
        if (currentDisplayModel != 4) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId id = new ContextId(2, -1L, 0L);
            if (currentDisplayModel != 3) {
                LayoutContext tableContext = styleResolver.createAnonymousContext(id, context);
                this.suspendNonBlockElements();
                fc.addElement(3, 0x1000005, tableContext);
                this.contentGenerator.startedTable(tableContext);
            }
            LayoutContext sectionContext = styleResolver.createAnonymousContext(id, context);
            fc.addElement(4, 0x1000008, sectionContext);
            this.contentGenerator.startedTableSection(sectionContext);
        }
        fc.addElement(5, 7, context);
        this.contentGenerator.startedTableRow(context);
    }

    private void addTableCell(LayoutContext context) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        int currentDisplayModel = fc.getCurrentDisplayModel();
        if (currentDisplayModel != 5) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId id = new ContextId(2, -1L, 0L);
            if (currentDisplayModel != 3 && currentDisplayModel != 4) {
                this.suspendNonBlockElements();
                LayoutContext tableContext = styleResolver.createAnonymousContext(id, context);
                fc.addElement(3, 0x1000005, tableContext);
                this.contentGenerator.startedTable(tableContext);
                currentDisplayModel = 3;
            }
            if (currentDisplayModel != 4) {
                LayoutContext sectionContext = styleResolver.createAnonymousContext(id, context);
                fc.addElement(4, 0x1000008, sectionContext);
                this.contentGenerator.startedTableSection(sectionContext);
            }
            LayoutContext rowContext = styleResolver.createAnonymousContext(id, context);
            fc.addElement(5, 0x1000007, rowContext);
            this.contentGenerator.startedTableRow(rowContext);
        }
        fc.addElement(1, 6, context);
        this.contentGenerator.startedTableCell(context);
    }

    private void addToBlockLevelBox(LayoutContext context) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        CSSValue displayRole = context.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.INLINE.equals(displayRole)) {
            CSSValue displayModel;
            if (!this.reactivateSuspendedInlines(fc)) {
                StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
                ContextId id = new ContextId(2, -1L, 0L);
                LayoutContext paragraphContext = styleResolver.createAnonymousContext(id, context);
                fc.addElement(2, 0x100000D, paragraphContext);
                this.contentGenerator.startedRootInline(paragraphContext);
            }
            if (DisplayModel.TABLE.equals(displayModel = context.getValue(BoxStyleKeys.DISPLAY_MODEL))) {
                fc.addElement(3, 2, context);
                this.contentGenerator.startedTable(context);
            } else if (DisplayModel.INLINE_INSIDE.equals(displayModel)) {
                fc.addElement(2, 2, context);
                this.contentGenerator.startedInline(context);
            } else {
                fc.addElement(1, 1, context);
                this.contentGenerator.startedBlock(context);
            }
            return;
        }
        CSSValue displayModel = context.getValue(BoxStyleKeys.DISPLAY_MODEL);
        if (DisplayModel.TABLE.equals(displayModel)) {
            fc.addElement(3, 5, context);
            this.contentGenerator.startedTable(context);
        } else if (DisplayModel.INLINE_INSIDE.equals(displayModel)) {
            fc.addElement(2, 1, context);
            this.contentGenerator.startedBlock(context);
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId id = new ContextId(2, -1L, 0L);
            LayoutContext paragraphContext = styleResolver.createAnonymousContext(id, context);
            fc.addElement(2, 0x100000D, paragraphContext);
            this.contentGenerator.startedRootInline(paragraphContext);
        } else {
            fc.addElement(1, 1, context);
            this.contentGenerator.startedBlock(context);
        }
    }

    private void addToInlineLevelBox(LayoutContext context) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        CSSValue displayRole = context.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.INLINE.equals(displayRole)) {
            CSSValue displayModel = context.getValue(BoxStyleKeys.DISPLAY_MODEL);
            if (DisplayModel.TABLE.equals(displayModel)) {
                fc.addElement(3, 5, context);
                this.contentGenerator.startedTable(context);
            } else if (DisplayModel.INLINE_INSIDE.equals(displayModel)) {
                fc.addElement(2, 2, context);
                this.contentGenerator.startedInline(context);
            } else {
                fc.addElement(1, 1, context);
                this.contentGenerator.startedBlock(context);
            }
            return;
        }
        this.suspendNonBlockElements();
        this.addToBlockLevelBox(context);
    }

    private void suspendNonBlockElements() throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        int model = fc.getCurrentDisplayModel();
        while (model != 1) {
            int currentDisplayRole = fc.getCurrentDisplayRole();
            this.callFinish(currentDisplayRole);
            fc.suspend();
            model = fc.getCurrentDisplayModel();
        }
    }

    private void addToTableLevelBox(LayoutContext context) throws NormalizationException {
        StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
        ContextId id = new ContextId(2, -1L, 0L);
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        LayoutContext sectionContext = styleResolver.createAnonymousContext(id, context);
        fc.addElement(4, 0x1000008, sectionContext);
        this.contentGenerator.startedTableSection(sectionContext);
        LayoutContext rowContext = styleResolver.createAnonymousContext(id, sectionContext);
        fc.addElement(5, 0x1000007, rowContext);
        this.contentGenerator.startedTableRow(rowContext);
        LayoutContext cellContext = styleResolver.createAnonymousContext(id, rowContext);
        fc.addElement(1, 0x1000006, cellContext);
        this.contentGenerator.startedTableCell(cellContext);
        this.addToBlockLevelBox(context);
    }

    public void addContent(ContentToken content) throws NormalizationException {
        FlowContext fc = (FlowContext)this.flowContexts.peek();
        LayoutContext layoutContext = fc.getCurrentLayoutContext();
        if (this.suspendCounter > 0) {
            this.contentGenerator.addPassThroughContent(layoutContext, content);
            return;
        }
        int currentDisplayModel = fc.getActiveDisplayModel();
        if (currentDisplayModel == 1) {
            if (!this.reactivateSuspendedInlines(fc)) {
                StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
                ContextId id = new ContextId(2, -1L, 0L);
                LayoutContext paragraphContext = styleResolver.createAnonymousContext(id, layoutContext);
                fc.addElement(2, 0x100000D, paragraphContext);
                this.contentGenerator.startedRootInline(paragraphContext);
                this.contentGenerator.addContent(paragraphContext, content);
            } else {
                this.contentGenerator.addContent(layoutContext, content);
            }
            return;
        }
        if (currentDisplayModel == 2) {
            this.reactivateSuspendedInlines(fc);
            this.contentGenerator.addContent(layoutContext, content);
        } else {
            this.contentGenerator.addContent(layoutContext, content);
        }
    }

    private boolean reactivateSuspendedInlines(FlowContext fc) throws NormalizationException {
        if (fc.getCurrentState() != 1) {
            return false;
        }
        IntList roles = new IntList(5);
        IntList models = new IntList(5);
        FastStack contexts = new FastStack();
        while (fc.getCurrentState() == 1) {
            contexts.push((Object)fc.getCurrentLayoutContext());
            roles.push(fc.getCurrentDisplayRole());
            models.push(fc.getCurrentDisplayModel());
            fc.close();
        }
        while (!contexts.isEmpty()) {
            LayoutContext lc = (LayoutContext)contexts.pop();
            int role = roles.pop();
            int model = models.pop();
            int cleanRole = role & 0xFFFFFF;
            if (cleanRole == 2) {
                this.contentGenerator.startedInline(lc);
                fc.addElement(model, role, lc);
                continue;
            }
            if (cleanRole == 13) {
                this.contentGenerator.startedRootInline(lc);
                fc.addElement(model, role, lc);
                continue;
            }
            throw new IllegalStateException("Unexpected role: " + cleanRole);
        }
        return true;
    }

    public void endElement() throws NormalizationException {
        int role;
        if (this.suspendCounter > 0) {
            this.contentGenerator.finishedPassThrough();
            --this.suspendCounter;
            return;
        }
        FlowContext context = (FlowContext)this.flowContexts.peek();
        do {
            role = context.getCurrentDisplayRole();
            if (context.getCurrentState() == 0) {
                this.callFinish(role);
            } else {
                LayoutContext layoutContext = context.getCurrentLayoutContext();
            }
            context.close();
            if (role != 14) continue;
            context = (FlowContext)this.flowContexts.peek();
        } while ((role & 0x1000000) == 0x1000000 && !context.isEmpty());
    }

    public void endDocument() throws NormalizationException {
        this.endElement();
        FlowContext context = (FlowContext)this.flowContexts.pop();
        this.contentGenerator.finishedDocument();
    }

    private void callFinish(int type) throws NormalizationException {
        switch (type & 0xFFFFFF) {
            case 1: {
                this.contentGenerator.finishedBlock();
                break;
            }
            case 14: {
                this.contentGenerator.finishedFlow();
                break;
            }
            case 5: {
                this.contentGenerator.finishedTable();
                break;
            }
            case 11: {
                this.contentGenerator.finishedTableCaption();
                break;
            }
            case 6: {
                this.contentGenerator.finishedTableCell();
                break;
            }
            case 10: {
                this.contentGenerator.finishedTableColumn();
                break;
            }
            case 9: {
                this.contentGenerator.finishedTableColumnGroup();
                break;
            }
            case 7: {
                this.contentGenerator.finishedTableRow();
                break;
            }
            case 8: {
                this.contentGenerator.finishedTableSection();
                break;
            }
            case 2: {
                this.contentGenerator.finishedInline();
                break;
            }
            case 3: {
                this.contentGenerator.finishedMarker();
                break;
            }
            case 13: {
                this.contentGenerator.finishedRootInline();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void handlePageBreak(PageContext pageContext) throws NormalizationException {
        this.contentGenerator.handlePageBreak(pageContext);
    }

    public Renderer getRenderer() {
        return this.contentGenerator.getRenderer();
    }

    public State saveState() throws StateException {
        return new FastDisplayModelBuilderState(this);
    }

    private static class FastDisplayModelBuilderState
    implements State {
        private FlowContext[] contexts;
        private int suspendCounter;
        private State contentGeneratorState;

        public FastDisplayModelBuilderState(FastDisplayModelBuilder builder) throws StateException {
            this.contentGeneratorState = builder.contentGenerator.saveState();
            this.suspendCounter = builder.suspendCounter;
            this.contexts = new FlowContext[builder.flowContexts.size()];
            try {
                for (int i = 0; i < this.contexts.length; ++i) {
                    FlowContext flowContext = (FlowContext)builder.flowContexts.get(i);
                    this.contexts[i] = (FlowContext)flowContext.clone();
                }
            }
            catch (CloneNotSupportedException cne) {
                throw new StateException("Cloning failed.", cne);
            }
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            try {
                FastDisplayModelBuilder fmb = new FastDisplayModelBuilder();
                fmb.layoutProcess = layoutProcess;
                fmb.flowContexts = new FastStack();
                fmb.suspendCounter = this.suspendCounter;
                for (int i = 0; i < this.contexts.length; ++i) {
                    FlowContext context = this.contexts[i];
                    fmb.flowContexts.push(context.clone());
                }
                fmb.contentGenerator = (ContentGenerator)this.contentGeneratorState.restore(layoutProcess);
                return fmb;
            }
            catch (CloneNotSupportedException e) {
                throw new StateException("Clone failed", e);
            }
        }
    }
}

