/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.generator;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.generator.ContentGenerator;
import org.jfree.layouting.renderer.Renderer;

public class DefaultContentGenerator
implements ContentGenerator {
    private Renderer renderer;

    public DefaultContentGenerator(LayoutProcess layoutProcess) {
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.renderer = layoutProcess.getOutputProcessor().createRenderer(layoutProcess);
    }

    protected DefaultContentGenerator(Renderer renderer) {
        this.renderer = renderer;
    }

    public void startedDocument(PageContext pageContext) {
        this.renderer.startedDocument(pageContext);
    }

    public void startedFlow(LayoutContext element) throws NormalizationException {
        this.renderer.startedFlow(element);
    }

    public void startedTable(LayoutContext element) throws NormalizationException {
        this.renderer.startedTable(element);
    }

    public void startedTableColumnGroup(LayoutContext element) throws NormalizationException {
        this.renderer.startedTableColumnGroup(element);
    }

    public void startedTableColumn(LayoutContext element) throws NormalizationException {
        this.renderer.startedTableColumn(element);
    }

    public void startedTableSection(LayoutContext element) throws NormalizationException {
        this.renderer.startedTableSection(element);
    }

    public void startedTableRow(LayoutContext element) throws NormalizationException {
        this.renderer.startedTableRow(element);
    }

    public void startedTableCell(LayoutContext element) throws NormalizationException {
        this.renderer.startedTableCell(element);
    }

    public void startedBlock(LayoutContext element) throws NormalizationException {
        this.renderer.startedBlock(element);
    }

    public void startedMarker(LayoutContext element) throws NormalizationException {
        this.renderer.startedMarker(element);
    }

    public void startedRootInline(LayoutContext element) throws NormalizationException {
        this.renderer.startedRootInline(element);
    }

    public void startedInline(LayoutContext element) throws NormalizationException {
        this.renderer.startedInline(element);
    }

    public void addContent(LayoutContext node, ContentToken contentToken) throws NormalizationException {
        this.renderer.addContent(node, contentToken);
    }

    public void finishedInline() throws NormalizationException {
        this.renderer.finishedInline();
    }

    public void finishedMarker() throws NormalizationException {
        this.renderer.finishedMarker();
    }

    public void finishedRootInline() throws NormalizationException {
        this.renderer.finishedRootInline();
    }

    public void finishedBlock() throws NormalizationException {
        this.renderer.finishedBlock();
    }

    public void finishedTableCell() throws NormalizationException {
        this.renderer.finishedTableCell();
    }

    public void finishedTableRow() throws NormalizationException {
        this.renderer.finishedTableRow();
    }

    public void finishedTableSection() throws NormalizationException {
        this.renderer.finishedTableSection();
    }

    public void finishedTableColumn() throws NormalizationException {
        this.renderer.finishedTableColumn();
    }

    public void finishedTableColumnGroup() throws NormalizationException {
        this.renderer.finishedTableColumnGroup();
    }

    public void finishedTable() throws NormalizationException {
        this.renderer.finishedTable();
    }

    public void finishedFlow() throws NormalizationException {
        this.renderer.finishedFlow();
    }

    public void finishedDocument() throws NormalizationException {
        this.renderer.finishedDocument();
    }

    public void handlePageBreak(PageContext pageContext) {
        this.renderer.handlePageBreak(pageContext);
    }

    public void startedPassThrough(LayoutContext element) throws NormalizationException {
        this.renderer.startedPassThrough(element);
    }

    public void addPassThroughContent(LayoutContext node, ContentToken token) throws NormalizationException {
        this.renderer.addPassThroughContent(node, token);
    }

    public void finishedPassThrough() throws NormalizationException {
        this.renderer.finishedPassThrough();
    }

    public State saveState() throws StateException {
        DefaultContentGeneratorState state = new DefaultContentGeneratorState();
        state.setRendererState(this.renderer.saveState());
        return state;
    }

    public void startedTableCaption(LayoutContext context) throws NormalizationException {
        this.renderer.startedTableCaption(context);
    }

    public void finishedTableCaption() throws NormalizationException {
        this.renderer.finishedTableCaption();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private static class DefaultContentGeneratorState
    implements State {
        private State rendererState;

        public State getRendererState() {
            return this.rendererState;
        }

        public void setRendererState(State rendererState) {
            this.rendererState = rendererState;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            return new DefaultContentGenerator((Renderer)this.rendererState.restore(layoutProcess));
        }
    }
}

