/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output.pageable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.output.AbstractOutputProcessor;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.output.pageable.PageFlowSelector;
import org.jfree.layouting.output.pageable.PageableOutputProcessor;
import org.jfree.layouting.output.pageable.PhysicalPageKey;
import org.jfree.layouting.renderer.PaginatingRenderer;
import org.jfree.layouting.renderer.PrototypeBuildingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.util.Configuration;

public abstract class AbstractPageableProcessor
extends AbstractOutputProcessor
implements PageableOutputProcessor {
    private List physicalPages = new ArrayList();
    private PrototypeBuildingRenderer prototypeBuilder;

    protected AbstractPageableProcessor(Configuration configuration) {
        super(configuration);
    }

    public Renderer createRenderer(LayoutProcess layoutProcess) {
        if (!this.isGlobalStateComputed()) {
            this.prototypeBuilder = new PrototypeBuildingRenderer(layoutProcess);
            return this.prototypeBuilder;
        }
        return new PaginatingRenderer(layoutProcess);
    }

    public PrototypeBuildingRenderer getPrototypeBuilder() {
        return this.prototypeBuilder;
    }

    protected void processingPagesFinished() {
        super.processingPagesFinished();
        this.physicalPages = Collections.unmodifiableList(this.physicalPages);
    }

    public int getPhysicalPageCount() {
        return this.physicalPages.size();
    }

    public PhysicalPageKey getPhysicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return (PhysicalPageKey)this.physicalPages.get(page);
    }

    protected LogicalPageKey createLogicalPage(int width, int height) {
        LogicalPageKey key = super.createLogicalPage(width, height);
        for (int h = 0; h < key.getHeight(); ++h) {
            for (int w = 0; w < key.getWidth(); ++w) {
                this.physicalPages.add(key.getPage(w, h));
            }
        }
        return key;
    }

    protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) {
        PageGrid pageGrid = logicalPage.getPageGrid();
        int rowCount = pageGrid.getRowCount();
        int colCount = pageGrid.getColumnCount();
        PageFlowSelector selector = this.getFlowSelector();
        if (selector != null) {
            if (selector.isLogicalPageAccepted(logicalPageKey)) {
                this.processLogicalPage(logicalPageKey, logicalPage);
            }
            for (int row = 0; row < rowCount; ++row) {
                for (int col = 0; col < colCount; ++col) {
                    PhysicalPageKey pageKey = logicalPageKey.getPage(col, row);
                    if (!selector.isPhysicalPageAccepted(pageKey)) continue;
                    this.processPhysicalPage(pageGrid, logicalPage, row, col, pageKey);
                }
            }
        }
    }

    protected abstract PageFlowSelector getFlowSelector();

    protected abstract void processPhysicalPage(PageGrid var1, LogicalPageBox var2, int var3, int var4, PhysicalPageKey var5);

    protected abstract void processLogicalPage(LogicalPageKey var1, LogicalPageBox var2);
}

