/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.jfree.base.log.MemoryUsageMessage;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.renderer.AbstractRenderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.process.CleanPaginatedBoxesStep;
import org.jfree.layouting.renderer.process.ComputeBreakabilityStep;
import org.jfree.layouting.renderer.process.ComputeICMMetricsStep;
import org.jfree.layouting.renderer.process.ComputeMarginsStep;
import org.jfree.layouting.renderer.process.ComputeStaticPropertiesStep;
import org.jfree.layouting.renderer.process.ComputeTableICMMetricsStep;
import org.jfree.layouting.renderer.process.FillPhysicalPagesStep;
import org.jfree.layouting.renderer.process.InfiniteMajorAxisLayoutStep;
import org.jfree.layouting.renderer.process.InfiniteMinorAxisLayoutStep;
import org.jfree.layouting.renderer.process.PaginationStep;
import org.jfree.layouting.renderer.process.ParagraphLineBreakStep;
import org.jfree.layouting.renderer.process.TableRowHeightStep;
import org.jfree.layouting.renderer.process.TableValidationStep;
import org.jfree.layouting.renderer.process.UpdateTokensStep;
import org.jfree.layouting.renderer.process.ValidateModelStep;
import org.jfree.util.Log;

public class PaginatingRenderer
extends AbstractRenderer {
    private ValidateModelStep validateModelStep;
    private TableValidationStep tableValidationStep;
    private ComputeStaticPropertiesStep staticPropertiesStep;
    private ComputeMarginsStep marginsStep;
    private ComputeICMMetricsStep icmMetricsStep;
    private ComputeTableICMMetricsStep tableICMMetricsStep;
    private ParagraphLineBreakStep paragraphLinebreakStep;
    private InfiniteMinorAxisLayoutStep minorAxisLayoutStep;
    private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;
    private TableRowHeightStep tableRowHeightStep;
    private ComputeBreakabilityStep breakabilityStep;
    private PaginationStep paginationStep;
    private FillPhysicalPagesStep fillPhysicalPagesStep;
    private CleanPaginatedBoxesStep cleanPaginatedBoxesStep;
    private UpdateTokensStep updateTokensStep;

    protected PaginatingRenderer(LayoutProcess layoutProcess, boolean init) {
        super(layoutProcess, init);
        if (init) {
            this.validateModelStep = new ValidateModelStep();
            this.staticPropertiesStep = new ComputeStaticPropertiesStep();
            this.tableValidationStep = new TableValidationStep();
            this.marginsStep = new ComputeMarginsStep();
            this.paragraphLinebreakStep = new ParagraphLineBreakStep();
            this.icmMetricsStep = new ComputeICMMetricsStep();
            this.tableICMMetricsStep = new ComputeTableICMMetricsStep();
            this.minorAxisLayoutStep = new InfiniteMinorAxisLayoutStep();
            this.majorAxisLayoutStep = new InfiniteMajorAxisLayoutStep();
            this.tableRowHeightStep = new TableRowHeightStep();
            this.breakabilityStep = new ComputeBreakabilityStep();
            this.paginationStep = new PaginationStep();
            this.fillPhysicalPagesStep = new FillPhysicalPagesStep();
            this.cleanPaginatedBoxesStep = new CleanPaginatedBoxesStep();
            this.updateTokensStep = new UpdateTokensStep();
        }
    }

    public PaginatingRenderer(LayoutProcess layoutProcess) {
        this(layoutProcess, true);
    }

    protected void validateOutput() throws NormalizationException {
        LogicalPageBox logicalPageBox = this.getLogicalPageBox();
        if (!this.validateModelStep.isLayoutable(logicalPageBox)) {
            this.setLayoutFailureReason(this.validateModelStep.getLayoutFailureResolution(), this.validateModelStep.getLayoutFailureNodeId());
            return;
        }
        this.tableValidationStep.validate(logicalPageBox);
        this.updateTokensStep.compute(logicalPageBox, this.getLayoutProcess(), this.getPageContext());
        this.staticPropertiesStep.compute(logicalPageBox);
        this.marginsStep.compute(logicalPageBox);
        this.paragraphLinebreakStep.compute(logicalPageBox);
        this.icmMetricsStep.compute(logicalPageBox);
        boolean repeat = true;
        while (repeat) {
            this.tableICMMetricsStep.compute(logicalPageBox);
            this.minorAxisLayoutStep.compute(logicalPageBox);
            this.majorAxisLayoutStep.compute(logicalPageBox);
            this.tableRowHeightStep.compute(logicalPageBox);
            this.breakabilityStep.compute(logicalPageBox);
            if (this.paginationStep.performPagebreak(logicalPageBox) || !logicalPageBox.isOpen()) {
                OutputProcessor outputProcessor = this.getLayoutProcess().getOutputProcessor();
                long nextOffset = this.paginationStep.getNextOffset();
                long pageOffset = logicalPageBox.getPageOffset();
                LogicalPageBox box = this.fillPhysicalPagesStep.compute(logicalPageBox, pageOffset, nextOffset);
                outputProcessor.processContent(box);
                repeat = logicalPageBox.isOpen();
                if (repeat) {
                    Log.debug((Object)new MemoryUsageMessage("PAGEBREAK ENCOUNTERED"));
                    Log.debug((Object)("Page-Offset: " + pageOffset + " -> " + nextOffset));
                    this.firePagebreak();
                    logicalPageBox.setPageOffset(nextOffset);
                    this.cleanPaginatedBoxesStep.compute(logicalPageBox);
                    continue;
                }
                outputProcessor.processingFinished();
                continue;
            }
            repeat = false;
        }
    }

    protected void firePagebreak() throws NormalizationException {
        PageContext pageContext = this.getRenderPageContext().getPageContext();
        LayoutStyle style = pageContext.getStyle();
        this.getLayoutProcess().pageBreakEncountered(null, new PseudoPage[0]);
    }

    public State saveState() throws StateException {
        return new DefaultFlowRendererState(this);
    }

    protected static class DefaultFlowRendererState
    extends AbstractRenderer.RendererState {
        private ValidateModelStep validateModelStep;
        private TableValidationStep tableValidationStep;
        private ComputeStaticPropertiesStep staticPropertiesStep;
        private ComputeMarginsStep marginsStep;
        private ComputeICMMetricsStep icmMetricsStep;
        private ComputeTableICMMetricsStep tableICMMetricsStep;
        private ParagraphLineBreakStep paragraphLinebreakStep;
        private InfiniteMinorAxisLayoutStep minorAxisLayoutStep;
        private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;
        private TableRowHeightStep tableRowHeightStep;
        private ComputeBreakabilityStep breakabilityStep;
        private PaginationStep paginationStep;
        private FillPhysicalPagesStep fillPhysicalPagesStep;
        private CleanPaginatedBoxesStep cleanPaginatedBoxesStep;
        private UpdateTokensStep updateTokensStep;

        protected DefaultFlowRendererState(PaginatingRenderer renderer) throws StateException {
            super(renderer);
            this.validateModelStep = renderer.validateModelStep;
            this.tableValidationStep = renderer.tableValidationStep;
            this.staticPropertiesStep = renderer.staticPropertiesStep;
            this.marginsStep = renderer.marginsStep;
            this.icmMetricsStep = renderer.icmMetricsStep;
            this.tableICMMetricsStep = renderer.tableICMMetricsStep;
            this.paragraphLinebreakStep = renderer.paragraphLinebreakStep;
            this.minorAxisLayoutStep = renderer.minorAxisLayoutStep;
            this.majorAxisLayoutStep = renderer.majorAxisLayoutStep;
            this.tableRowHeightStep = renderer.tableRowHeightStep;
            this.breakabilityStep = renderer.breakabilityStep;
            this.paginationStep = renderer.paginationStep;
            this.fillPhysicalPagesStep = renderer.fillPhysicalPagesStep;
            this.cleanPaginatedBoxesStep = renderer.cleanPaginatedBoxesStep;
            this.updateTokensStep = renderer.updateTokensStep;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            PaginatingRenderer defaultRenderer = new PaginatingRenderer(layoutProcess, false);
            this.fill(defaultRenderer, layoutProcess);
            defaultRenderer.validateModelStep = this.validateModelStep;
            defaultRenderer.tableValidationStep = this.tableValidationStep;
            defaultRenderer.staticPropertiesStep = this.staticPropertiesStep;
            defaultRenderer.marginsStep = this.marginsStep;
            defaultRenderer.icmMetricsStep = this.icmMetricsStep;
            defaultRenderer.tableICMMetricsStep = this.tableICMMetricsStep;
            defaultRenderer.paragraphLinebreakStep = this.paragraphLinebreakStep;
            defaultRenderer.minorAxisLayoutStep = this.minorAxisLayoutStep;
            defaultRenderer.majorAxisLayoutStep = this.majorAxisLayoutStep;
            defaultRenderer.tableRowHeightStep = this.tableRowHeightStep;
            defaultRenderer.paginationStep = this.paginationStep;
            defaultRenderer.fillPhysicalPagesStep = this.fillPhysicalPagesStep;
            defaultRenderer.cleanPaginatedBoxesStep = this.cleanPaginatedBoxesStep;
            defaultRenderer.breakabilityStep = this.breakabilityStep;
            defaultRenderer.updateTokensStep = this.updateTokensStep;
            return defaultRenderer;
        }
    }
}

