/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.border;

import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.util.geom.StrictGeomUtility;

public class RenderLength {
    public static final RenderLength AUTO = new RenderLength(Long.MIN_VALUE, false);
    public static final RenderLength EMPTY = new RenderLength(0L, false);
    private long value;
    private boolean percentage;

    public RenderLength(long value, boolean percentage) {
        this.value = value;
        this.percentage = percentage;
    }

    public long getValue() {
        return this.value;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderLength that = (RenderLength)o;
        if (this.percentage != that.percentage) {
            return false;
        }
        return this.value == that.value;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 29 * result + (this.percentage ? 1 : 0);
        return result;
    }

    public long resolve(long parent) {
        if (this.isPercentage()) {
            return StrictGeomUtility.multiply(this.value, parent) / 100L;
        }
        if (this.value == Long.MIN_VALUE) {
            return 0L;
        }
        return this.value;
    }

    public RenderLength resolveToRenderLength(long parent) {
        if (this.isPercentage()) {
            if (parent <= 0L) {
                return AUTO;
            }
            return new RenderLength(StrictGeomUtility.multiply(this.value, parent) / 100L, false);
        }
        if (this.value <= 0L) {
            return AUTO;
        }
        return new RenderLength(this.value, false);
    }

    public static RenderLength convertToInternal(CSSValue value, LayoutContext layoutContext, OutputProcessorMetaData metaData) {
        if (value instanceof CSSNumericValue) {
            CSSNumericValue nval = (CSSNumericValue)value;
            if (nval.getType() == CSSNumericType.PERCENTAGE) {
                return new RenderLength(StrictGeomUtility.toInternalValue(nval.getValue()), true);
            }
            if (nval.getType() == CSSNumericType.NUMBER) {
                return new RenderLength(StrictGeomUtility.toInternalValue(nval.getValue()) * 100L, true);
            }
            CSSNumericValue cssNumericValue = CSSValueResolverUtility.convertLength(value, layoutContext, metaData);
            return new RenderLength(StrictGeomUtility.toInternalValue(cssNumericValue.getValue()), false);
        }
        return EMPTY;
    }

    public String toString() {
        if (this.value == Long.MIN_VALUE) {
            return "RenderLength{value=AUTO}";
        }
        if (this.isPercentage()) {
            return "RenderLength{value=" + this.value + "% }";
        }
        return "RenderLength{value=" + this.value + "pt }";
    }
}

