/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BoxDefinition;

public class DefaultBoxDefinition
implements BoxDefinition {
    private RenderLength marginTop = RenderLength.EMPTY;
    private RenderLength marginBottom;
    private RenderLength marginLeft = RenderLength.EMPTY;
    private RenderLength marginRight;
    private RenderLength paddingTop;
    private RenderLength paddingLeft;
    private RenderLength paddingBottom;
    private RenderLength paddingRight;
    private Border border;
    private RenderLength minimumWidth;
    private RenderLength minimumHeight;
    private RenderLength maximumWidth;
    private RenderLength maximumHeight;
    private RenderLength preferredWidth;
    private RenderLength preferredHeight;
    private CSSColorValue backgroundColor;
    private Boolean empty;

    public DefaultBoxDefinition() {
        this.marginBottom = RenderLength.EMPTY;
        this.marginRight = RenderLength.EMPTY;
        this.paddingTop = RenderLength.EMPTY;
        this.paddingLeft = RenderLength.EMPTY;
        this.paddingBottom = RenderLength.EMPTY;
        this.paddingRight = RenderLength.EMPTY;
        this.maximumWidth = RenderLength.EMPTY;
        this.maximumHeight = RenderLength.EMPTY;
        this.minimumWidth = RenderLength.EMPTY;
        this.minimumHeight = RenderLength.EMPTY;
        this.preferredWidth = RenderLength.EMPTY;
        this.preferredHeight = RenderLength.EMPTY;
        this.border = Border.createEmptyBorder();
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        if (border == null) {
            throw new NullPointerException();
        }
        this.border = border;
    }

    public RenderLength getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(RenderLength marginTop) {
        if (marginTop == null) {
            throw new NullPointerException();
        }
        this.marginTop = marginTop;
    }

    public RenderLength getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(RenderLength marginBottom) {
        if (marginBottom == null) {
            throw new NullPointerException();
        }
        this.marginBottom = marginBottom;
    }

    public RenderLength getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(RenderLength marginLeft) {
        if (marginLeft == null) {
            throw new NullPointerException();
        }
        this.marginLeft = marginLeft;
    }

    public RenderLength getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(RenderLength marginRight) {
        if (marginRight == null) {
            throw new NullPointerException();
        }
        this.marginRight = marginRight;
    }

    public RenderLength getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(RenderLength paddingTop) {
        if (paddingTop == null) {
            throw new NullPointerException();
        }
        this.paddingTop = paddingTop;
    }

    public RenderLength getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(RenderLength paddingLeft) {
        if (paddingLeft == null) {
            throw new NullPointerException();
        }
        this.paddingLeft = paddingLeft;
    }

    public RenderLength getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(RenderLength paddingBottom) {
        if (paddingBottom == null) {
            throw new NullPointerException();
        }
        this.paddingBottom = paddingBottom;
    }

    public RenderLength getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(RenderLength paddingRight) {
        if (paddingRight == null) {
            throw new NullPointerException();
        }
        this.paddingRight = paddingRight;
    }

    public RenderLength getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(RenderLength minimumWidth) {
        if (minimumWidth == null) {
            throw new NullPointerException();
        }
        this.minimumWidth = minimumWidth;
    }

    public RenderLength getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(RenderLength minimumHeight) {
        if (minimumHeight == null) {
            throw new NullPointerException();
        }
        this.minimumHeight = minimumHeight;
    }

    public RenderLength getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(RenderLength maximumWidth) {
        if (maximumWidth == null) {
            throw new NullPointerException();
        }
        this.maximumWidth = maximumWidth;
    }

    public RenderLength getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setMaximumHeight(RenderLength maximumHeight) {
        if (maximumHeight == null) {
            throw new NullPointerException();
        }
        this.maximumHeight = maximumHeight;
    }

    public RenderLength getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(RenderLength preferredWidth) {
        if (preferredWidth == null) {
            throw new NullPointerException();
        }
        this.preferredWidth = preferredWidth;
    }

    public RenderLength getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(RenderLength preferredHeight) {
        if (preferredHeight == null) {
            throw new NullPointerException();
        }
        this.preferredHeight = preferredHeight;
    }

    public BoxDefinition[] split(int axis) {
        if (axis == 0) {
            return this.splitVertically();
        }
        return this.splitHorizontally();
    }

    public BoxDefinition[] splitVertically() {
        Border[] borders = this.border.splitVertically(null);
        DefaultBoxDefinition first = new DefaultBoxDefinition();
        first.marginTop = this.marginTop;
        first.marginLeft = this.marginLeft;
        first.marginBottom = this.marginBottom;
        first.marginRight = RenderLength.EMPTY;
        first.paddingBottom = this.paddingBottom;
        first.paddingTop = this.paddingTop;
        first.paddingLeft = this.paddingLeft;
        first.paddingRight = RenderLength.EMPTY;
        first.border = borders[0];
        first.preferredHeight = this.preferredHeight;
        first.preferredWidth = this.preferredWidth;
        first.minimumHeight = this.minimumHeight;
        first.minimumWidth = this.minimumWidth;
        first.maximumHeight = this.maximumHeight;
        first.maximumWidth = this.maximumWidth;
        DefaultBoxDefinition second = new DefaultBoxDefinition();
        second.marginTop = this.marginTop;
        second.marginLeft = RenderLength.EMPTY;
        second.marginBottom = this.marginBottom;
        second.marginRight = this.marginRight;
        second.paddingBottom = this.paddingBottom;
        second.paddingTop = this.paddingTop;
        second.paddingLeft = RenderLength.EMPTY;
        second.paddingRight = this.paddingRight;
        second.border = borders[1];
        second.preferredHeight = this.preferredHeight;
        second.preferredWidth = this.preferredWidth;
        second.minimumHeight = this.minimumHeight;
        second.minimumWidth = this.minimumWidth;
        second.maximumHeight = this.maximumHeight;
        second.maximumWidth = this.maximumWidth;
        BoxDefinition[] boxes = new BoxDefinition[]{first, second};
        return boxes;
    }

    public BoxDefinition[] splitHorizontally() {
        Border[] borders = this.border.splitHorizontally(null);
        DefaultBoxDefinition first = new DefaultBoxDefinition();
        first.marginTop = this.marginTop;
        first.marginLeft = this.marginLeft;
        first.marginBottom = RenderLength.EMPTY;
        first.marginRight = this.marginRight;
        first.paddingBottom = RenderLength.EMPTY;
        first.paddingTop = this.paddingTop;
        first.paddingLeft = this.paddingLeft;
        first.paddingRight = this.paddingRight;
        first.border = borders[0];
        first.preferredHeight = this.preferredHeight;
        first.preferredWidth = this.preferredWidth;
        first.minimumHeight = this.minimumHeight;
        first.minimumWidth = this.minimumWidth;
        first.maximumHeight = this.maximumHeight;
        first.maximumWidth = this.maximumWidth;
        DefaultBoxDefinition second = new DefaultBoxDefinition();
        second.marginTop = RenderLength.EMPTY;
        second.marginLeft = this.marginLeft;
        second.marginBottom = this.marginBottom;
        second.marginRight = this.marginRight;
        second.paddingBottom = this.paddingBottom;
        second.paddingTop = RenderLength.EMPTY;
        second.paddingLeft = this.paddingLeft;
        second.paddingRight = this.paddingRight;
        second.border = borders[1];
        second.preferredHeight = this.preferredHeight;
        second.preferredWidth = this.preferredWidth;
        second.minimumHeight = this.minimumHeight;
        second.minimumWidth = this.minimumWidth;
        second.maximumHeight = this.maximumHeight;
        second.maximumWidth = this.maximumWidth;
        BoxDefinition[] boxes = new BoxDefinition[]{first, second};
        return boxes;
    }

    public CSSColorValue getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(CSSColorValue backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isEmpty() {
        if (this.empty != null) {
            return this.empty;
        }
        if (this.paddingTop.getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.paddingLeft.getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.paddingBottom.getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.paddingRight.getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.border.isEmpty()) {
            this.empty = Boolean.FALSE;
            return false;
        }
        this.empty = Boolean.TRUE;
        return true;
    }
}

