/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.color.CSSSystemColors;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.BorderFactory;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.BoxDefinitionFactory;
import org.jfree.layouting.renderer.model.DefaultBoxDefinition;

public class DefaultBoxDefinitionFactory
implements BoxDefinitionFactory {
    private BorderFactory borderFactory;

    public DefaultBoxDefinitionFactory(BorderFactory borderFactory) {
        this.borderFactory = borderFactory;
    }

    public BoxDefinition createBlockBoxDefinition(LayoutContext boxContext, OutputProcessorMetaData metaData) {
        Border border = this.borderFactory.createBorder(boxContext, metaData);
        DefaultBoxDefinition boxDefinition = new DefaultBoxDefinition();
        boxDefinition.setBorder(border);
        CSSValue value = boxContext.getValue(BorderStyleKeys.BACKGROUND_COLOR);
        if (value instanceof CSSColorValue) {
            boxDefinition.setBackgroundColor((CSSColorValue)value);
        } else {
            boxDefinition.setBackgroundColor(CSSSystemColors.TRANSPARENT);
        }
        this.fillHorizontalPadding(boxDefinition, boxContext, metaData);
        boxDefinition.setPreferredWidth(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.WIDTH), boxContext, metaData, true, true));
        boxDefinition.setMarginLeft(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MARGIN_LEFT), boxContext, metaData, true, true));
        boxDefinition.setMarginRight(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MARGIN_RIGHT), boxContext, metaData, true, true));
        this.fillVerticalModel(boxDefinition, boxContext, metaData);
        return boxDefinition;
    }

    public BoxDefinition createInlineBoxDefinition(LayoutContext boxContext, OutputProcessorMetaData metaData) {
        Border border = this.borderFactory.createBorder(boxContext, metaData);
        DefaultBoxDefinition boxDefinition = new DefaultBoxDefinition();
        boxDefinition.setBorder(border);
        CSSValue value = boxContext.getValue(BorderStyleKeys.BACKGROUND_COLOR);
        if (value instanceof CSSColorValue) {
            boxDefinition.setBackgroundColor((CSSColorValue)value);
        } else {
            boxDefinition.setBackgroundColor(CSSSystemColors.TRANSPARENT);
        }
        this.fillHorizontalPadding(boxDefinition, boxContext, metaData);
        boxDefinition.setPreferredWidth(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.WIDTH), boxContext, metaData, true, true));
        boxDefinition.setMarginLeft(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MARGIN_LEFT), boxContext, metaData, false, true));
        boxDefinition.setMarginRight(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MARGIN_RIGHT), boxContext, metaData, false, true));
        this.fillVerticalModel(boxDefinition, boxContext, metaData);
        return boxDefinition;
    }

    private void fillVerticalModel(DefaultBoxDefinition boxDefinition, LayoutContext boxContext, OutputProcessorMetaData metaData) {
        boxDefinition.setPaddingTop(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.PADDING_TOP), boxContext, metaData, false, false));
        boxDefinition.setPaddingBottom(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.PADDING_BOTTOM), boxContext, metaData, false, false));
        boxDefinition.setMarginTop(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MARGIN_TOP), boxContext, metaData, false, true));
        boxDefinition.setMarginBottom(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MARGIN_BOTTOM), boxContext, metaData, false, true));
        boxDefinition.setPreferredHeight(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.HEIGHT), boxContext, metaData, true, true));
    }

    private void fillHorizontalPadding(DefaultBoxDefinition boxDefinition, LayoutContext boxContext, OutputProcessorMetaData metaData) {
        boxDefinition.setPaddingLeft(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.PADDING_LEFT), boxContext, metaData, false, false));
        boxDefinition.setPaddingRight(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.PADDING_RIGHT), boxContext, metaData, false, false));
        boxDefinition.setMaximumWidth(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MAX_WIDTH), boxContext, metaData, false, false));
        boxDefinition.setMaximumHeight(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MAX_HEIGHT), boxContext, metaData, false, false));
        boxDefinition.setMinimumWidth(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MIN_WIDTH), boxContext, metaData, false, false));
        boxDefinition.setMinimumHeight(DefaultBoxDefinitionFactory.computeWidth(boxContext.getValue(BoxStyleKeys.MIN_HEIGHT), boxContext, metaData, false, false));
    }

    public static RenderLength computeWidth(CSSValue widthValue, LayoutContext boxContext, OutputProcessorMetaData metaData, boolean allowAuto, boolean allowNegativeValues) {
        RenderLength renderLength;
        if (allowAuto && CSSAutoValue.getInstance().equals(widthValue)) {
            return RenderLength.AUTO;
        }
        if (!(widthValue instanceof CSSNumericValue)) {
            return RenderLength.EMPTY;
        }
        CSSNumericValue nval = (CSSNumericValue)widthValue;
        if (nval.getValue() < 0.0 && allowNegativeValues) {
            return RenderLength.convertToInternal(widthValue, boxContext, metaData);
        }
        if (nval.getValue() > 0.0 && (renderLength = RenderLength.convertToInternal(widthValue, boxContext, metaData)).getValue() > 0L) {
            return renderLength;
        }
        return RenderLength.EMPTY;
    }
}

