/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.NodeLayoutProperties;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;

public abstract class RenderNode
implements Cloneable {
    public static final int HORIZONTAL_AXIS = 0;
    public static final int VERTICAL_AXIS = 1;
    private RenderBox parent;
    private RenderNode prev;
    private RenderNode next;
    private long changeTracker;
    private long width;
    private long height;
    private long x;
    private long y;
    private boolean frozen;
    private boolean hibernated;
    private Object instanceId = new Object();
    private NodeLayoutProperties layoutProperties = new NodeLayoutProperties();
    private LayoutContext layoutContext;
    private boolean dirty;
    private long maximumBoxWidth;
    private long minimumChunkWidth;
    private boolean icmMetricsFinished;
    private long stickyMarker;
    private ComputedLayoutProperties computedLayoutProperties;

    public void appyStyle(LayoutContext context, OutputProcessorMetaData metaData) {
        this.layoutProperties.setAlignmentBaseline(context.getValue(LineStyleKeys.ALIGNMENT_BASELINE));
        CSSValue alignmentAdjust = context.getValue(LineStyleKeys.ALIGNMENT_ADJUST);
        this.layoutProperties.setAlignmentAdjust(alignmentAdjust);
        if (alignmentAdjust instanceof CSSNumericValue) {
            this.layoutProperties.setAlignmentAdjustResolved(RenderLength.convertToInternal(alignmentAdjust, context, metaData));
        }
        CSSValue baselineShift = context.getValue(LineStyleKeys.BASELINE_SHIFT);
        this.layoutProperties.setBaselineShift(baselineShift);
        if (baselineShift instanceof CSSNumericValue) {
            this.layoutProperties.setBaselineShiftResolved(RenderLength.convertToInternal(baselineShift, context, metaData));
        }
        this.layoutProperties.setVerticalAlignment(this.normalizeAlignment(context.getValue(LineStyleKeys.VERTICAL_ALIGN)));
        this.layoutProperties.setNamespace(context.getNamespace());
        this.layoutProperties.setTagName(context.getTagName());
        this.layoutContext = context;
    }

    public ComputedLayoutProperties getComputedLayoutProperties() {
        return this.computedLayoutProperties;
    }

    public void setComputedLayoutProperties(ComputedLayoutProperties clp) {
        this.computedLayoutProperties = clp;
    }

    public LayoutContext getLayoutContext() {
        return this.layoutContext;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getNamespace() {
        return this.layoutProperties.getNamespace();
    }

    public String getTagName() {
        return this.layoutProperties.getTagName();
    }

    protected CSSValue normalizeAlignment(CSSValue verticalAlignment) {
        return verticalAlignment;
    }

    public CSSValue getVerticalAlignment() {
        return this.layoutProperties.getVerticalAlignment();
    }

    public RenderLength getBaselineShiftResolved() {
        return this.layoutProperties.getBaselineShiftResolved();
    }

    public CSSValue getAlignmentBaseline() {
        return this.layoutProperties.getAlignmentBaseline();
    }

    public CSSValue getBaselineShift() {
        return this.layoutProperties.getBaselineShift();
    }

    public CSSValue getAlignmentAdjust() {
        return this.layoutProperties.getAlignmentAdjust();
    }

    public RenderLength getAlignmentAdjustResolved() {
        return this.layoutProperties.getAlignmentAdjustResolved();
    }

    public PageContext getPageContext() {
        RenderBox parent = this.getParent();
        if (parent != null) {
            parent.getPageContext();
        }
        return null;
    }

    public Object getInstanceId() {
        return this.instanceId;
    }

    public int getMajorAxis() {
        return this.layoutProperties.getMajorAxis();
    }

    protected void setMajorAxis(int majorAxis) {
        this.layoutProperties.setMajorAxis(majorAxis);
    }

    public int getMinorAxis() {
        return this.layoutProperties.getMinorAxis();
    }

    protected void setMinorAxis(int minorAxis) {
        this.layoutProperties.setMinorAxis(minorAxis);
        this.updateChangeTracker();
    }

    public void setWidth(long width) {
        if (width < 0L) {
            throw new IllegalArgumentException("Width cannot be negative: " + width);
        }
        this.width = width;
        this.updateChangeTracker();
    }

    public long getWidth() {
        return this.width;
    }

    public void setHeight(long height) {
        if (height < 0L) {
            throw new IllegalArgumentException("Height cannot be negative: " + height);
        }
        this.height = height;
    }

    public long getHeight() {
        return this.height;
    }

    public long getX() {
        return this.x;
    }

    public void setX(long x) {
        this.x = x;
        this.updateChangeTracker();
    }

    public final void setPosition(int axis, long value) {
        if (axis == 0) {
            this.setX(value);
        } else {
            this.setY(value);
        }
    }

    public final long getPosition(int axis) {
        if (axis == 0) {
            return this.getX();
        }
        return this.getY();
    }

    public final void setDimension(int axis, long value) {
        if (axis == 0) {
            this.setWidth(value);
        } else {
            this.setHeight(value);
        }
    }

    public final long getDimension(int axis) {
        if (axis == 0) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    public long getY() {
        return this.y;
    }

    public void setY(long y) {
        this.y = y;
    }

    public RenderBox getParent() {
        return this.parent;
    }

    protected void setParent(RenderBox parent) {
        this.parent = parent;
        if (parent != null && this.prev == parent) {
            throw new IllegalStateException();
        }
    }

    public RenderNode getVisiblePrev() {
        for (RenderNode node = this.prev; node != null; node = node.getPrev()) {
            if (node.isIgnorableForRendering()) continue;
            return node;
        }
        return null;
    }

    public RenderNode getPrev() {
        return this.prev;
    }

    protected void setPrev(RenderNode prev) {
        this.prev = prev;
        if (prev != null && prev == this.parent) {
            throw new IllegalStateException();
        }
    }

    public RenderNode getVisibleNext() {
        for (RenderNode node = this.next; node != null; node = node.getNext()) {
            if (node.isIgnorableForRendering()) continue;
            return node;
        }
        return null;
    }

    public RenderNode getNext() {
        return this.next;
    }

    protected void setNext(RenderNode next) {
        this.next = next;
    }

    public LogicalPageBox getLogicalPage() {
        RenderBox parent = this.getParent();
        if (parent != null) {
            return parent.getLogicalPage();
        }
        return null;
    }

    public NormalFlowRenderBox getNormalFlow() {
        RenderBox parent = this.getParent();
        if (parent != null) {
            return parent.getNormalFlow();
        }
        return null;
    }

    public Object clone() {
        try {
            RenderNode renderNode = (RenderNode)super.clone();
            return renderNode;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed for some reason.");
        }
    }

    public RenderNode derive(boolean deep) {
        RenderNode node = (RenderNode)this.clone();
        node.parent = null;
        node.next = null;
        node.prev = null;
        node.hibernated = false;
        return node;
    }

    public RenderNode hibernate() {
        RenderNode node = (RenderNode)this.clone();
        node.parent = null;
        node.next = null;
        node.prev = null;
        node.hibernated = true;
        return node;
    }

    public RenderNode deriveFrozen(boolean deep) {
        RenderNode node = (RenderNode)this.clone();
        node.parent = null;
        node.next = null;
        node.prev = null;
        node.frozen = true;
        node.hibernated = false;
        return node;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isHibernated() {
        return this.hibernated;
    }

    protected void setHibernated(boolean hibernated) {
        this.hibernated = hibernated;
    }

    public RenderNode findNodeById(Object instanceId) {
        if (instanceId == this.getInstanceId()) {
            return this;
        }
        return null;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public RenderBox getParentBlockContext() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BlockRenderBox) {
            return this.parent;
        }
        return this.parent.getParentBlockContext();
    }

    public boolean isDiscardable() {
        return false;
    }

    public boolean isIgnorableForRendering() {
        return this.isEmpty();
    }

    public NodeLayoutProperties getNodeLayoutProperties() {
        return this.layoutProperties;
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isDirectionLTR() {
        return true;
    }

    public void updateChangeTracker() {
        ++this.changeTracker;
        if (this.parent != null) {
            this.parent.updateChangeTracker();
        }
    }

    public long getChangeTracker() {
        return this.changeTracker;
    }

    public long getStickyMarker() {
        return this.stickyMarker;
    }

    public void setStickyMarker(long stickyMarker) {
        this.stickyMarker = stickyMarker;
    }

    public long getEffectiveMarginTop() {
        return 0L;
    }

    public long getEffectiveMarginBottom() {
        return 0L;
    }

    public long getMaximumBoxWidth() {
        return this.maximumBoxWidth;
    }

    public void setMaximumBoxWidth(long maximumBoxWidth) {
        this.maximumBoxWidth = maximumBoxWidth;
    }

    public long getMinimumChunkWidth() {
        return this.minimumChunkWidth;
    }

    public void setMinimumChunkWidth(long minimumChunkWidth) {
        this.minimumChunkWidth = minimumChunkWidth;
    }

    public boolean isIcmMetricsFinished() {
        return this.icmMetricsFinished;
    }

    public void setIcmMetricsFinished(boolean icmMetricsFinished) {
        this.icmMetricsFinished = icmMetricsFinished;
    }
}

