/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.fonts.text.Spacing;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;
import org.jfree.layouting.renderer.text.Glyph;

public class RenderableText
extends RenderNode {
    private Glyph[] glyphs;
    private int offset;
    private int length;
    private boolean ltr;
    private int script;
    private long minimumWidth;
    private long preferredWidth;
    private boolean forceLinebreak;
    private ExtendedBaselineInfo baselineInfo;

    protected RenderableText() {
    }

    public RenderableText(ExtendedBaselineInfo baselineInfo, Glyph[] glyphs, int offset, int length, int script, boolean forceLinebreak) {
        this.initialize(glyphs, offset, length, baselineInfo, script, forceLinebreak);
    }

    protected void initialize(Glyph[] glyphs, int offset, int length, ExtendedBaselineInfo baselineInfo, int script, boolean forceLinebreak) {
        if (glyphs == null) {
            throw new NullPointerException();
        }
        if (glyphs.length < offset + length) {
            throw new IllegalArgumentException();
        }
        this.baselineInfo = baselineInfo;
        this.ltr = true;
        this.script = script;
        this.glyphs = glyphs;
        this.offset = offset;
        this.length = length;
        this.forceLinebreak = forceLinebreak;
        this.setMajorAxis(0);
        this.setMinorAxis(1);
        long wordMinChunkWidth = 0L;
        long wordMinWidth = 0L;
        long wordPrefWidth = 0L;
        long wordMaxWidth = 0L;
        long minimumChunkWidth = 0L;
        int lastPos = Math.min(glyphs.length, offset + length);
        for (int i = offset; i < lastPos; ++i) {
            Glyph glyph = glyphs[i];
            Spacing spacing = glyph.getSpacing();
            int kerning = glyph.getKerning();
            int width = glyph.getWidth();
            if (glyph.getBreakWeight() <= 1) {
                wordMinChunkWidth += (long)(width + spacing.getMinimum() - kerning);
                wordMinWidth += (long)(width + spacing.getMinimum() - kerning);
                wordPrefWidth += (long)(width + spacing.getOptimum() - kerning);
                wordMaxWidth += (long)(width + spacing.getMaximum() - kerning);
                continue;
            }
            wordMinWidth += (long)(width + spacing.getMinimum() - kerning);
            wordPrefWidth += (long)(width + spacing.getOptimum() - kerning);
            wordMaxWidth += (long)(width + spacing.getMaximum() - kerning);
            minimumChunkWidth = Math.max(minimumChunkWidth, wordMinChunkWidth += (long)(width + spacing.getMinimum() - kerning));
            wordMinWidth = 0L;
            if (glyph.getBreakWeight() != 4) continue;
            throw new IllegalStateException("A renderable text cannot and must not contain linebreaks.");
        }
        minimumChunkWidth = Math.max(minimumChunkWidth, wordMinChunkWidth);
        this.minimumWidth = Math.max(this.minimumWidth, wordMinWidth);
        this.preferredWidth = Math.max(this.preferredWidth, wordPrefWidth);
        long maximumWidth = Math.max(this.minimumWidth, wordMaxWidth);
        this.setMaximumBoxWidth(maximumWidth);
        this.setMinimumChunkWidth(minimumChunkWidth);
        this.setIcmMetricsFinished(true);
    }

    public boolean isForceLinebreak() {
        return this.forceLinebreak;
    }

    public boolean isLtr() {
        return this.ltr;
    }

    public Glyph[] getGlyphs() {
        return this.glyphs;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getRawText() {
        Glyph[] gs = this.getGlyphs();
        int length = this.getLength();
        StringBuffer b = new StringBuffer();
        for (int i = this.getOffset(); i < length; ++i) {
            Glyph g = gs[i];
            b.append((char)(0xFFFF & g.getCodepoint()));
            int[] extraCPs = g.getExtraChars();
            for (int j = 0; j < extraCPs.length; ++j) {
                int extraCP = extraCPs[j];
                b.append(extraCP);
            }
        }
        return b.toString();
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean isDiscardable() {
        if (this.forceLinebreak) {
            return false;
        }
        return this.glyphs.length == 0;
    }

    public ExtendedBaselineInfo getBaselineInfo() {
        return this.baselineInfo;
    }

    public int getScript() {
        return this.script;
    }

    public long getMinimumWidth() {
        return this.minimumWidth;
    }

    public long getPreferredWidth() {
        return this.preferredWidth;
    }
}

