/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.page;

import java.util.Arrays;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.EmptyBoxDefinition;
import org.jfree.layouting.renderer.model.NodeLayoutProperties;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.PageAreaRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;

public class LogicalPageBox
extends BlockRenderBox {
    private PageGrid pageGrid;
    private long[] pageWidths;
    private long[] pageHeights;
    private long[] horizontalBreaks;
    private long[] verticalBreaks;
    private long pageWidth;
    private long pageHeight;
    private Object contentAreaId;
    private PageAreaRenderBox footerArea;
    private PageAreaRenderBox headerArea;
    private long pageOffset;
    private boolean normalFlowActive;

    public LogicalPageBox(PageGrid pageGrid) {
        super(EmptyBoxDefinition.getInstance());
        if (pageGrid == null) {
            throw new NullPointerException("PageGrid must not be null");
        }
        NormalFlowRenderBox contentArea = new NormalFlowRenderBox(EmptyBoxDefinition.getInstance());
        this.contentAreaId = contentArea.getInstanceId();
        this.headerArea = new PageAreaRenderBox(EmptyBoxDefinition.getInstance());
        this.headerArea.setParent(this);
        this.footerArea = new PageAreaRenderBox(EmptyBoxDefinition.getInstance());
        this.footerArea.setParent(this);
        this.updatePageArea(pageGrid);
        this.addChild(contentArea);
        this.setMajorAxis(1);
        this.setMinorAxis(0);
        NodeLayoutProperties nodeLayoutProperties = this.getNodeLayoutProperties();
        nodeLayoutProperties.setNamespace("http://jfreereport.sourceforge.net/namespaces/layout");
        nodeLayoutProperties.setTagName("logical-page");
    }

    public void appyStyle(LayoutContext context, OutputProcessorMetaData metaData) {
        super.appyStyle(context, metaData);
        NodeLayoutProperties nodeLayoutProperties = this.getNodeLayoutProperties();
        nodeLayoutProperties.setNamespace("http://jfreereport.sourceforge.net/namespaces/layout");
        nodeLayoutProperties.setTagName("logical-page");
    }

    public void updatePageArea(PageGrid pageGrid) {
        int i;
        if (pageGrid == null) {
            throw new NullPointerException();
        }
        this.pageGrid = pageGrid;
        this.pageHeights = new long[pageGrid.getColumnCount()];
        this.pageWidths = new long[pageGrid.getRowCount()];
        this.horizontalBreaks = new long[pageGrid.getColumnCount()];
        this.verticalBreaks = new long[pageGrid.getRowCount()];
        Arrays.fill(this.pageHeights, Long.MAX_VALUE);
        Arrays.fill(this.pageWidths, Long.MAX_VALUE);
        for (int row = 0; row < pageGrid.getRowCount(); ++row) {
            for (int col = 0; col < pageGrid.getColumnCount(); ++col) {
                PhysicalPageBox box = pageGrid.getPage(row, col);
                this.pageHeights[row] = Math.min(this.pageHeights[row], box.getImageableHeight());
                this.pageWidths[col] = Math.min(this.pageWidths[col], box.getImageableWidth());
            }
        }
        this.pageHeight = 0L;
        for (i = 0; i < this.pageHeights.length; ++i) {
            this.pageHeight += this.pageHeights[i];
            this.verticalBreaks[i] = this.pageHeight;
        }
        this.pageWidth = 0L;
        for (i = 0; i < this.pageWidths.length; ++i) {
            this.pageWidth += this.pageWidths[i];
            this.horizontalBreaks[i] = this.pageWidth;
        }
    }

    public NormalFlowRenderBox getContentArea() {
        return (NormalFlowRenderBox)this.findNodeById(this.contentAreaId);
    }

    public PageAreaRenderBox getFooterArea() {
        return this.footerArea;
    }

    public PageAreaRenderBox getHeaderArea() {
        return this.headerArea;
    }

    public LogicalPageBox getLogicalPage() {
        return this;
    }

    public NormalFlowRenderBox getNormalFlow() {
        return this.getContentArea();
    }

    public PageGrid getPageGrid() {
        return this.pageGrid;
    }

    public RenderBox getInsertationPoint() {
        return this.getContentArea().getInsertationPoint();
    }

    public long[] getPhysicalBreaks(int axis) {
        if (axis == 0) {
            return (long[])this.horizontalBreaks.clone();
        }
        return (long[])this.verticalBreaks.clone();
    }

    public boolean isOverflow() {
        return false;
    }

    public RenderNode deriveFrozen(boolean deepDerive) {
        LogicalPageBox box = (LogicalPageBox)super.deriveFrozen(deepDerive);
        box.headerArea = (PageAreaRenderBox)this.headerArea.deriveFrozen(deepDerive);
        box.footerArea = (PageAreaRenderBox)this.footerArea.deriveFrozen(deepDerive);
        return box;
    }

    public RenderNode derive(boolean deepDerive) {
        LogicalPageBox box = (LogicalPageBox)super.derive(deepDerive);
        box.headerArea = (PageAreaRenderBox)this.headerArea.derive(deepDerive);
        box.footerArea = (PageAreaRenderBox)this.footerArea.derive(deepDerive);
        return box;
    }

    public RenderNode hibernate() {
        LogicalPageBox box = (LogicalPageBox)super.hibernate();
        box.headerArea = (PageAreaRenderBox)this.headerArea.hibernate();
        box.footerArea = (PageAreaRenderBox)this.footerArea.hibernate();
        return box;
    }

    public Object clone() {
        try {
            LogicalPageBox o = (LogicalPageBox)super.clone();
            o.pageHeights = (long[])this.pageHeights.clone();
            o.pageWidths = (long[])this.pageWidths.clone();
            o.pageGrid = (PageGrid)this.pageGrid.clone();
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Cloning *must* be supported.");
        }
    }

    public boolean isNormalFlowActive() {
        return this.normalFlowActive;
    }

    public long getPageHeight() {
        return this.pageHeight;
    }

    public long getPageWidth() {
        return this.pageWidth;
    }

    public long getPageOffset() {
        return this.pageOffset;
    }

    public void setPageOffset(long pageOffset) {
        this.pageOffset = pageOffset;
    }

    public void setNormalFlowActive(boolean normalFlowActive) {
        this.normalFlowActive = normalFlowActive;
    }

    public void insertFirst(RenderNode node) {
        this.insertBefore(this.getFirstChild(), node);
    }

    public void insertLast(RenderNode node) {
        this.insertAfter(this.getLastChild(), node);
    }

    public RenderNode findNodeById(Object instanceId) {
        RenderNode footerNode = this.footerArea.findNodeById(instanceId);
        if (footerNode != null) {
            return footerNode;
        }
        RenderNode headerNode = this.headerArea.findNodeById(instanceId);
        if (headerNode != null) {
            return headerNode;
        }
        return super.findNodeById(instanceId);
    }
}

