/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.page;

import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;

public class PageGridUtility {
    private PageGridUtility() {
    }

    public static PageSize lookupPageSize(CSSValue sizeVal, OutputProcessorMetaData metaData) {
        if (!(sizeVal instanceof CSSValuePair)) {
            PageSize defaultVal = metaData.getDefaultPageSize();
            return defaultVal;
        }
        CSSValuePair valuePair = (CSSValuePair)sizeVal;
        CSSValue firstValue = valuePair.getFirstValue();
        if (!(firstValue instanceof CSSNumericValue)) {
            PageSize defaultVal = metaData.getDefaultPageSize();
            return defaultVal;
        }
        CSSValue secondValue = valuePair.getSecondValue();
        if (!(secondValue instanceof CSSNumericValue)) {
            PageSize defaultVal = metaData.getDefaultPageSize();
            return defaultVal;
        }
        double width = CSSValueResolverUtility.convertLengthToDouble(firstValue, null, metaData);
        double height = CSSValueResolverUtility.convertLengthToDouble(secondValue, null, metaData);
        if (width < 1.0 || height < 1.0) {
            PageSize defaultVal = metaData.getDefaultPageSize();
            return defaultVal;
        }
        return new PageSize(width, height);
    }
}

