/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.page;

import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.page.PageGridUtility;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.jfree.util.Log;

public class PhysicalPageBox
implements Cloneable {
    private PageContext pageContext;
    private long width;
    private long height;
    private long imageableX;
    private long imageableY;
    private long imageableWidth;
    private long imageableHeight;
    private long globalX;
    private long globalY;

    public PhysicalPageBox(PageContext pageContext, OutputProcessorMetaData metaData, long globalX, long globalY) {
        this.globalX = globalX;
        this.globalY = globalY;
        this.pageContext = pageContext;
        LayoutStyle areaDefinition = pageContext.getAreaDefinition(PageAreaType.CONTENT);
        CSSValue pageValue = areaDefinition.getValue(PageStyleKeys.SIZE);
        PageSize pageSize = PageGridUtility.lookupPageSize(pageValue, metaData);
        this.width = StrictGeomUtility.toInternalValue(pageSize.getWidth());
        this.height = StrictGeomUtility.toInternalValue(pageSize.getHeight());
        CSSValue marginTopValue = areaDefinition.getValue(BoxStyleKeys.MARGIN_TOP);
        CSSValue marginLeftValue = areaDefinition.getValue(BoxStyleKeys.MARGIN_LEFT);
        CSSValue marginBottomValue = areaDefinition.getValue(BoxStyleKeys.MARGIN_BOTTOM);
        CSSValue marginRightValue = areaDefinition.getValue(BoxStyleKeys.MARGIN_RIGHT);
        long marginTop = PhysicalPageBox.computeWidth(marginTopValue, metaData).resolve(this.width);
        long marginLeft = PhysicalPageBox.computeWidth(marginLeftValue, metaData).resolve(this.width);
        long marginBottom = PhysicalPageBox.computeWidth(marginBottomValue, metaData).resolve(this.width);
        long marginRight = PhysicalPageBox.computeWidth(marginRightValue, metaData).resolve(this.width);
        this.imageableX = marginLeft;
        this.imageableY = marginTop;
        this.imageableWidth = Math.max(0L, this.width - marginLeft - marginRight);
        this.imageableHeight = Math.max(0L, this.height - marginTop - marginBottom);
        if (this.imageableWidth == 0L) {
            Log.warn((Object)"The Margins are invalid: Ignoring right.");
            this.imageableWidth = Math.max(0L, this.width - marginLeft);
            if (this.imageableWidth == 0L) {
                Log.warn((Object)"The Margins are totally messed up: Ignoring left and right");
                this.imageableWidth = Math.max(0L, this.width);
                if (this.imageableHeight == 0L) {
                    Log.warn((Object)"Oh, your page-size definition is funny: Using the built in default.");
                    this.imageableWidth = StrictGeomUtility.toInternalValue(metaData.getDefaultPageSize().getWidth());
                    if (this.imageableWidth <= 0L) {
                        throw new IllegalStateException("I tried everything to save you, but you ignored me.");
                    }
                }
            }
        }
        if (this.imageableHeight == 0L) {
            Log.warn((Object)"The Margins are invalid: Ignoring right.");
            this.imageableHeight = Math.max(0L, this.height - marginTop);
            if (this.imageableHeight == 0L) {
                Log.warn((Object)"The Margins are totally messed up: Ignoring left and right");
                this.imageableHeight = Math.max(0L, this.height);
                if (this.imageableHeight == 0L) {
                    Log.warn((Object)"Oh, your page-size definition is funny: Using the built in default.");
                    this.imageableHeight = StrictGeomUtility.toInternalValue(metaData.getDefaultPageSize().getHeight());
                    if (this.imageableHeight <= 0L) {
                        throw new IllegalStateException("I tried everything to save you, but you ignored me.");
                    }
                }
            }
        }
    }

    private static RenderLength computeWidth(CSSValue widthValue, OutputProcessorMetaData metaData) {
        RenderLength renderLength;
        if (!(widthValue instanceof CSSNumericValue)) {
            return RenderLength.EMPTY;
        }
        CSSNumericValue nval = (CSSNumericValue)widthValue;
        if (nval.getValue() > 0.0 && (renderLength = RenderLength.convertToInternal(widthValue, null, metaData)).getValue() > 0L) {
            return renderLength;
        }
        return RenderLength.EMPTY;
    }

    public long getImageableX() {
        return this.imageableX;
    }

    public long getImageableY() {
        return this.imageableY;
    }

    public long getImageableWidth() {
        return this.imageableWidth;
    }

    public long getImageableHeight() {
        return this.imageableHeight;
    }

    public long getGlobalX() {
        return this.globalX;
    }

    public void setGlobalX(long globalX) {
        this.globalX = globalX;
    }

    public long getGlobalY() {
        return this.globalY;
    }

    public void setGlobalY(long globalY) {
        this.globalY = globalY;
    }

    public long getWidth() {
        return this.width;
    }

    public long getHeight() {
        return this.height;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

