/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.keys.table.TableStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;

public class TableCellRenderBox
extends BlockRenderBox {
    private int colSpan;
    private int rowSpan;
    private boolean autoGenerated;
    private Border effectiveBorder;
    private int columnIndex;

    public TableCellRenderBox(BoxDefinition boxDefinition, boolean autoGenerated) {
        super(boxDefinition);
        this.autoGenerated = autoGenerated;
        this.colSpan = 1;
        this.rowSpan = 1;
        this.columnIndex = -1;
    }

    public TableCellRenderBox(BoxDefinition boxDefinition) {
        this(boxDefinition, false);
    }

    public void appyStyle(LayoutContext context, OutputProcessorMetaData metaData) {
        super.appyStyle(context, metaData);
        CSSValue csValue = context.getValue(TableStyleKeys.COL_SPAN);
        this.colSpan = (int)CSSValueResolverUtility.getNumericValue(csValue, 1.0);
        CSSValue rsValue = context.getValue(TableStyleKeys.ROW_SPAN);
        this.rowSpan = (int)CSSValueResolverUtility.getNumericValue(rsValue, 1.0);
    }

    protected CSSValue normalizeAlignment(CSSValue verticalAlignment) {
        if (VerticalAlign.BOTTOM.equals(verticalAlignment)) {
            return verticalAlignment;
        }
        if (VerticalAlign.TOP.equals(verticalAlignment)) {
            return verticalAlignment;
        }
        if (VerticalAlign.MIDDLE.equals(verticalAlignment)) {
            return verticalAlignment;
        }
        return VerticalAlign.BASELINE;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public RenderNode getCellNode() {
        return this;
    }

    public TableRenderBox getTable() {
        RenderBox parent = this.getParent();
        if (parent instanceof TableRowRenderBox) {
            TableRowRenderBox rowRenderBox = (TableRowRenderBox)parent;
            return rowRenderBox.getTable();
        }
        return null;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public boolean isIgnorableForRendering() {
        return false;
    }

    public Border getEffectiveBorder() {
        return this.effectiveBorder;
    }

    public void setEffectiveBorder(Border effectiveBorder) {
        this.effectiveBorder = effectiveBorder;
    }

    public Border getOriginalBorder() {
        return this.getBoxDefinition().getBorder();
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }
}

