/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;

public class TableRowRenderBox
extends BlockRenderBox {
    private boolean autoGenerated;
    private TableRowInfoStructure infoStructure;

    public TableRowRenderBox(BoxDefinition boxDefinition, boolean autoGenerated) {
        super(boxDefinition);
        this.autoGenerated = autoGenerated;
        this.infoStructure = new TableRowInfoStructure();
        this.setMajorAxis(0);
        this.setMinorAxis(1);
    }

    public TableRowInfoStructure getRowInfoStructure() {
        return this.infoStructure;
    }

    public boolean isIgnorableForRendering() {
        if (this.autoGenerated) {
            return false;
        }
        return super.isIgnorableForRendering();
    }

    public TableRenderBox getTable() {
        RenderBox parent = this.getParent();
        if (parent instanceof TableSectionRenderBox) {
            TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)parent;
            return tableSectionRenderBox.getTable();
        }
        return null;
    }

    public TableColumnModel getColumnModel() {
        TableRenderBox table = this.getTable();
        if (table == null) {
            return null;
        }
        return table.getColumnModel();
    }

    public Object clone() {
        try {
            TableRowRenderBox rb = (TableRowRenderBox)super.clone();
            if (!this.infoStructure.isValidationDone()) {
                rb.infoStructure = (TableRowInfoStructure)this.infoStructure.clone();
            }
            return rb;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone not supported is not supported.");
        }
    }
}

