/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.rows;

import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.util.LongList;

public class TableRow {
    private Border border;
    private long preferredSize;
    private long validateSize;
    private LongList preferredSizes;
    private long validatedLeadingSize;
    private LongList validatedTrailingSize;

    public TableRow() {
        this(Border.createEmptyBorder());
    }

    public TableRow(Border border) {
        this.border = border;
        this.preferredSizes = new LongList(10);
        this.validatedLeadingSize = 0L;
        this.validatedTrailingSize = new LongList(10);
    }

    public long getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(long preferredSize) {
        this.preferredSize = preferredSize;
    }

    public long getPreferredSize(int colspan) {
        int index = colspan - 1;
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (this.preferredSizes.size() <= index) {
            return 0L;
        }
        return this.preferredSizes.get(index);
    }

    public int getMaximumRowSpan() {
        return this.preferredSizes.size();
    }

    public void updateDefinedSize(int rowSpan, long preferredWidth) {
        if (rowSpan < 1) {
            throw new IllegalArgumentException();
        }
        int idx = rowSpan - 1;
        if (idx >= this.preferredSizes.size() || this.preferredSizes.get(idx) < preferredWidth) {
            this.preferredSizes.set(idx, preferredWidth);
        }
    }

    public long getValidatedLeadingSize() {
        return this.validatedLeadingSize;
    }

    public long getValidatedTrailingSize(int rowSpan) {
        if (rowSpan > this.validatedTrailingSize.size()) {
            return 0L;
        }
        return this.validatedTrailingSize.get(rowSpan - 1);
    }

    public void setValidatedTralingSize(int rowSpan, long validatedSize) {
        this.validatedTrailingSize.set(rowSpan - 1, validatedSize);
    }

    public int getMaxValidatedRowSpan() {
        return this.validatedTrailingSize.size();
    }

    public void updateValidatedSize(int rowSpan, long leading, long trailing) {
        int idx = rowSpan - 1;
        if (this.validatedLeadingSize < leading) {
            this.validatedLeadingSize = leading;
        }
        if (idx >= this.validatedTrailingSize.size() || this.validatedTrailingSize.get(idx) < trailing) {
            this.validatedTrailingSize.set(idx, trailing);
        }
    }

    public long getValidateSize() {
        return this.validateSize;
    }

    public void setValidateSize(long validateSize) {
        this.validateSize = validateSize;
    }

    public void clear() {
        this.validatedTrailingSize.clear();
        this.validateSize = 0L;
    }

    public void clearSizes() {
        this.preferredSizes.clear();
        this.preferredSize = 0L;
    }
}

