/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.layouting.renderer.ModelPrinter;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;
import org.jfree.layouting.renderer.process.InfiniteMinorAxisLayoutStep;
import org.jfree.layouting.renderer.process.TextAlignmentProcessor;
import org.jfree.layouting.renderer.process.layoutrules.EndSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.StartSequenceElement;
import org.jfree.layouting.util.LongList;
import org.jfree.util.FastStack;

public abstract class AbstractAlignmentProcessor
implements TextAlignmentProcessor {
    private static final int START = 0;
    private static final int CONTENT = 1;
    private static final int END = 2;
    private long startOfLine;
    private long endOfLine;
    private long[] pagebreaks;
    private PageGrid pageGrid;
    private InlineSequenceElement[] sequenceElements;
    private int sequenceFill;
    private int breakableIndex;
    private int skipIndex;
    private long[] elementPositions;
    private long[] elementDimensions;

    public long getStartOfLine() {
        return this.startOfLine;
    }

    public PageGrid getPageGrid() {
        return this.pageGrid;
    }

    protected InlineSequenceElement[] getSequenceElements() {
        return this.sequenceElements;
    }

    public long[] getElementPositions() {
        return this.elementPositions;
    }

    public long[] getElementDimensions() {
        return this.elementDimensions;
    }

    public long getEndOfLine() {
        return this.endOfLine;
    }

    protected long getPageBreak(int pageIndex) {
        return this.pagebreaks[pageIndex];
    }

    public int getBreakableIndex() {
        return this.breakableIndex;
    }

    public void setBreakableIndex(int breakableIndex) {
        this.breakableIndex = breakableIndex;
    }

    public int getSkipIndex() {
        return this.skipIndex;
    }

    public void setSkipIndex(int skipIndex) {
        this.skipIndex = skipIndex;
    }

    public int iterate(InlineSequenceElement[] elements, int maxPos) {
        this.breakableIndex = -1;
        this.skipIndex = -1;
        if (maxPos == 0) {
            return 0;
        }
        int lastElementType = this.classifyInput(elements[0]);
        int startIndex = 0;
        for (int i = 1; i < maxPos; ++i) {
            InlineSequenceElement element = elements[i];
            int elementType = this.classifyInput(element);
            if (elementType == 2) {
                lastElementType = elementType;
                continue;
            }
            if (lastElementType == 0) {
                lastElementType = elementType;
                continue;
            }
            int newIndex = this.handleElement(startIndex, i - startIndex);
            if (newIndex <= startIndex) {
                return startIndex;
            }
            startIndex = i;
            lastElementType = elementType;
        }
        return this.handleElement(startIndex, maxPos - startIndex);
    }

    public void initialize(InlineSequenceElement[] sequence, long start, long end, PageGrid breaks) {
        if (end < start) {
            throw new IllegalArgumentException("Start is <= end; which is stupid!: " + end + " " + start);
        }
        this.sequenceElements = sequence;
        this.sequenceFill = sequence.length;
        this.startOfLine = start;
        this.endOfLine = end;
        this.pageGrid = breaks;
        this.elementPositions = new long[this.sequenceElements.length];
        this.elementDimensions = new long[this.sequenceElements.length];
        this.updateBreaks();
    }

    private void updateBreaks() {
        int pageCnt = this.pageGrid.getColumnCount();
        LongList pageLongList = new LongList(pageCnt);
        long pos = 0L;
        for (int i = 0; i < pageCnt; ++i) {
            if (pos < this.startOfLine) continue;
            PhysicalPageBox page = this.pageGrid.getPage(0, i);
            if ((pos += page.getImageableWidth()) >= this.endOfLine) break;
            pageLongList.add(pos);
        }
        pageLongList.add(this.endOfLine);
        this.pagebreaks = pageLongList.toArray();
    }

    public boolean hasNext() {
        return this.sequenceFill > 0;
    }

    public RenderNode next() {
        RenderNode node;
        Arrays.fill(this.elementDimensions, 0L);
        Arrays.fill(this.elementPositions, 0L);
        int lastPosition = this.iterate(this.sequenceElements, this.sequenceFill);
        if (lastPosition == 0) {
            if (this.getBreakableIndex() >= 0) {
                // empty if block
            }
            lastPosition = this.getSkipIndex() >= 0 ? this.getSkipIndex() : this.sequenceFill;
        }
        ArrayList<RenderNode> pendingElements = new ArrayList<RenderNode>();
        FastStack contexts = new FastStack();
        RenderBox firstBox = null;
        RenderBox box = null;
        for (int i = 0; i < lastPosition; ++i) {
            RenderNode node2;
            InlineSequenceElement element = this.sequenceElements[i];
            if (element instanceof EndSequenceElement) {
                contexts.pop();
                long boxX2 = this.elementPositions[i] + this.elementDimensions[i];
                box.setWidth(boxX2 - box.getX());
                if (contexts.isEmpty()) {
                    box = null;
                    continue;
                }
                node2 = box;
                box = (RenderBox)contexts.peek();
                box.addGeneratedChild(node2);
                continue;
            }
            if (element instanceof StartSequenceElement) {
                RenderNode node3 = element.getNode();
                box = (RenderBox)node3.derive(false);
                box.setX(this.elementPositions[i]);
                contexts.push((Object)box);
                if (firstBox != null) continue;
                firstBox = box;
                continue;
            }
            if (box == null) {
                throw new IllegalStateException("Invalid sequence: Cannot have elements before we open the box context.");
            }
            RenderNode child = element.getNode().derive(true);
            child.setX(this.elementPositions[i]);
            child.setWidth(this.elementDimensions[i]);
            if (box.isPreserveSpace()) {
                box.addGeneratedChild(child);
                continue;
            }
            if (child.isIgnorableForRendering()) {
                pendingElements.add(child);
                continue;
            }
            for (int j = 0; j < pendingElements.size(); ++j) {
                node2 = (RenderNode)pendingElements.get(j);
                box.addGeneratedChild(node2);
            }
            pendingElements.clear();
            box.addGeneratedChild(child);
        }
        while (lastPosition < this.sequenceFill && (node = this.sequenceElements[lastPosition].getNode()).isDiscardable()) {
            ++lastPosition;
        }
        int openContexts = contexts.size();
        for (int i = 0; i < openContexts; ++i) {
            RenderBox renderBox = (RenderBox)contexts.get(i);
            renderBox.setWidth(this.getEndOfLine() - box.getX());
            InlineRenderBox rightBox = (InlineRenderBox)renderBox.split(0);
            this.sequenceElements[i] = new StartSequenceElement(rightBox);
        }
        int length = this.sequenceFill - lastPosition;
        System.arraycopy(this.sequenceElements, lastPosition, this.sequenceElements, openContexts, length);
        this.sequenceFill = openContexts + length;
        Arrays.fill(this.sequenceElements, this.sequenceFill, this.sequenceElements.length, null);
        return firstBox;
    }

    protected int handleElement(int start, int count) {
        int endIndex = start + count;
        InlineSequenceElement[] sequenceElements = this.getSequenceElements();
        int contentIndex = start;
        long width = 0L;
        for (int i = 0; i < endIndex; ++i) {
            InlineSequenceElement element = sequenceElements[i];
            width += element.getMaximumWidth();
            if (element instanceof StartSequenceElement || element instanceof EndSequenceElement) continue;
            contentIndex = i;
        }
        long pagebreak = this.getPageBreak(0);
        if (width > pagebreak) {
            return start;
        }
        return this.handleLayout(start, count, contentIndex, width);
    }

    protected abstract int handleLayout(int var1, int var2, int var3, long var4);

    private int classifyInput(InlineSequenceElement element) {
        if (element instanceof StartSequenceElement) {
            return 0;
        }
        if (element instanceof EndSequenceElement) {
            return 2;
        }
        return 1;
    }

    protected void computeInlineBlock(RenderBox box, long position, long itemElementWidth) {
        ComputedLayoutProperties blp = box.getComputedLayoutProperties();
        box.setX(position + blp.getMarginLeft());
        long width = itemElementWidth - blp.getMarginLeft() - blp.getMarginRight();
        if (width == 0L) {
            ModelPrinter.printParents(box);
            throw new IllegalStateException("A box without any width? " + Integer.toHexString(System.identityHashCode(box)) + " " + box.getClass());
        }
        box.setWidth(width);
        long leftInsets = blp.getPaddingLeft() + blp.getBorderLeft();
        long rightInsets = blp.getPaddingRight() + blp.getBorderRight();
        box.setContentAreaX1(box.getX() + leftInsets);
        box.setContentAreaX2(box.getX() + box.getWidth() - rightInsets);
        InfiniteMinorAxisLayoutStep layoutStep = new InfiniteMinorAxisLayoutStep();
        layoutStep.continueComputation(this.getPageGrid(), box);
    }
}

