/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;

public class BoxShifter {
    public void shiftBox(RenderBox box, long amount) {
        if (amount == 0L) {
            return;
        }
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot shift upwards: " + amount);
        }
        box.setY(box.getY() + amount);
        this.shiftBoxInternal(box, amount);
    }

    public void shiftBoxUnchecked(RenderBox box, long amount) {
        if (amount == 0L) {
            return;
        }
        box.setY(box.getY() + amount);
        this.shiftBoxInternal(box, amount);
    }

    private void shiftBoxInternal(RenderBox box, long amount) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            node.setY(node.getY() + amount);
            if (!(node instanceof RenderBox)) continue;
            this.shiftBoxInternal((RenderBox)node, amount);
        }
    }

    public void extendHeight(RenderNode node, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot shrink elements.");
        }
        if (node == null || amount == 0L) {
            return;
        }
        node.setHeight(node.getHeight() + amount);
        for (RenderBox parent = node.getParent(); parent != null; parent = parent.getParent()) {
            parent.setHeight(parent.getHeight() + amount);
        }
    }
}

