/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.FinishedRenderNode;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class ComputeBreakabilityStep
extends IterateVisualProcessStep {
    public void compute(LogicalPageBox logicalPageBox) {
        this.startProcessing(logicalPageBox);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    protected void finishBlockLevelBox(RenderBox box) {
        if (box instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraph = (ParagraphRenderBox)box;
            this.finishParagraph(paragraph);
            return;
        }
        if (box instanceof TableRenderBox) {
            TableRenderBox table = (TableRenderBox)box;
            this.finishTable(table);
            return;
        }
        if (box instanceof TableRowRenderBox) {
            TableRowRenderBox row = (TableRowRenderBox)box;
            this.finishTableRow(row);
            return;
        }
        RenderNode firstNode = this.findNonFinishedVisibleFirst(box);
        if (firstNode instanceof RenderBox) {
            RenderBox firstBox = (RenderBox)firstNode;
            box.setOrphansSize(firstBox.getOrphansSize());
        } else if (firstNode != null) {
            box.setOrphansSize(firstNode.getHeight());
        }
        RenderNode lastNode = this.findNonFinishedVisibleLast(box);
        if (lastNode instanceof RenderBox) {
            RenderBox lastBox = (RenderBox)lastNode;
            box.setWidowsSize(lastBox.getOrphansSize());
        } else if (lastNode != null) {
            box.setWidowsSize(lastNode.getHeight());
        }
    }

    private RenderNode findNonFinishedVisibleFirst(RenderBox box) {
        RenderNode node = box.getVisibleFirst();
        while (node instanceof FinishedRenderNode) {
            node = node.getVisibleNext();
        }
        return node;
    }

    private RenderNode findNonFinishedVisibleLast(RenderBox box) {
        RenderNode node = box.getVisibleLast();
        while (node instanceof FinishedRenderNode) {
            node = node.getVisiblePrev();
        }
        return node;
    }

    private void finishTableRow(TableRowRenderBox box) {
        long orphanSize = 0L;
        long widowSize = 0L;
        int linecount = 0;
        RenderNode node = box.getVisibleFirst();
        while (node != null) {
            if (!(node instanceof RenderBox)) {
                node = node.getVisibleNext();
                continue;
            }
            RenderBox cellBox = (RenderBox)node;
            orphanSize = Math.max(cellBox.getOrphansSize(), orphanSize);
            widowSize = Math.max(cellBox.getWidowsSize(), widowSize);
            linecount = Math.max(cellBox.getLineCount(), linecount);
            node = node.getVisibleNext();
        }
        box.setOrphansSize(orphanSize);
        box.setWidowsSize(widowSize);
        box.setLineCount(linecount);
    }

    private void finishTable(TableRenderBox box) {
        RenderNode node = box.getVisibleFirst();
        if (node instanceof RenderBox) {
            RenderBox firstBox = (RenderBox)node;
            box.setOrphansSize(firstBox.getOrphansSize());
        } else {
            box.setOrphansSize(box.getHeight());
        }
        node = box.getVisibleLast();
        if (node instanceof RenderBox) {
            RenderBox lastBox = (RenderBox)node;
            box.setWidowsSize(lastBox.getWidowsSize());
        } else {
            box.setWidowsSize(box.getHeight());
        }
    }

    private void finishParagraph(ParagraphRenderBox box) {
        long nodeY2;
        RenderNode node;
        int lineCount = 0;
        for (node = box.getVisibleFirst(); node != null && ++lineCount != box.getOrphans(); node = node.getVisibleNext()) {
        }
        if (node == null) {
            box.setOrphansSize(box.getHeight());
        } else {
            nodeY2 = node.getY() + node.getHeight();
            box.setOrphansSize(nodeY2 - box.getY());
        }
        lineCount = 0;
        for (node = box.getVisibleLast(); node != null && ++lineCount != box.getWidows(); node = node.getVisiblePrev()) {
        }
        if (node == null) {
            box.setWidowsSize(box.getHeight());
        } else {
            nodeY2 = node.getY() + node.getHeight();
            long paragraphY2 = box.getY() + box.getHeight();
            box.setWidowsSize(paragraphY2 - nodeY2);
        }
    }
}

