/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;
import org.jfree.layouting.util.geom.StrictDimension;

public class ComputeICMMetricsStep
extends IterateVisualProcessStep {
    public void compute(LogicalPageBox root) {
        this.startProcessing(root);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box.getLineboxContainer());
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        return true;
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        return true;
    }

    protected void finishInlineLevelBox(RenderBox box) {
        ComputedLayoutProperties blp = box.getComputedLayoutProperties();
        long hbp = blp.getBorderLeft() + blp.getBorderRight() + blp.getPaddingLeft() + blp.getPaddingRight() + blp.getMarginLeft() + blp.getMarginRight();
        long minChunkWidth = 0L;
        long maxBoxWidth = 0L;
        for (RenderNode node = box.getVisibleFirst(); node != null; node = node.getVisibleNext()) {
            maxBoxWidth += node.getMaximumBoxWidth();
            long childChunkWidth = node.getMinimumChunkWidth();
            if (childChunkWidth <= minChunkWidth) continue;
            minChunkWidth = childChunkWidth;
        }
        box.setMinimumChunkWidth(hbp + minChunkWidth);
        box.setMaximumBoxWidth(hbp + maxBoxWidth);
        box.setIcmMetricsFinished(!box.isOpen());
    }

    protected void finishBlockLevelBox(RenderBox box) {
        ComputedLayoutProperties blp = box.getComputedLayoutProperties();
        long hbp = blp.getBorderLeft() + blp.getBorderRight() + blp.getPaddingLeft() + blp.getPaddingRight() + blp.getMarginLeft() + blp.getMarginRight();
        if (box instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraph = (ParagraphRenderBox)box;
            BlockRenderBox linebox = paragraph.getLineboxContainer();
            box.setMinimumChunkWidth(hbp + linebox.getMinimumChunkWidth());
            box.setMaximumBoxWidth(hbp + linebox.getMaximumBoxWidth());
            box.setIcmMetricsFinished(!box.isOpen());
            return;
        }
        long minChunkWidth = 0L;
        long maxBoxWidth = 0L;
        for (RenderNode node = box.getVisibleFirst(); node != null; node = node.getVisibleNext()) {
            long childBoxWidth;
            long childChunkWidth = node.getMinimumChunkWidth();
            if (childChunkWidth > minChunkWidth) {
                minChunkWidth = childChunkWidth;
            }
            if ((childBoxWidth = node.getMaximumBoxWidth()) <= maxBoxWidth) continue;
            maxBoxWidth = childBoxWidth;
        }
        box.setMinimumChunkWidth(hbp + minChunkWidth);
        box.setMaximumBoxWidth(hbp + maxBoxWidth);
        box.setIcmMetricsFinished(!box.isOpen());
    }

    protected void processInlineLevelNode(RenderNode node) {
        if (node.isIcmMetricsFinished()) {
            return;
        }
        if (node instanceof RenderableReplacedContent) {
            RenderableReplacedContent rpc = (RenderableReplacedContent)node;
            RenderLength requestedWidth = rpc.getRequestedWidth();
            StrictDimension contentSize = rpc.getContentSize();
            if (requestedWidth == RenderLength.AUTO) {
                node.setMaximumBoxWidth(contentSize.getWidth());
            } else {
                node.setMaximumBoxWidth(requestedWidth.resolve(contentSize.getWidth()));
            }
            node.setMinimumChunkWidth(0L);
            node.setIcmMetricsFinished(true);
        }
    }

    protected void processBlockLevelNode(RenderNode node) {
        if (node.isIcmMetricsFinished()) {
            return;
        }
        if (node instanceof RenderableReplacedContent) {
            RenderableReplacedContent rpc = (RenderableReplacedContent)node;
            RenderLength requestedWidth = rpc.getRequestedWidth();
            StrictDimension contentSize = rpc.getContentSize();
            if (requestedWidth == RenderLength.AUTO) {
                node.setMaximumBoxWidth(contentSize.getWidth());
            } else {
                node.setMaximumBoxWidth(requestedWidth.resolve(contentSize.getWidth()));
            }
            node.setMinimumChunkWidth(0L);
            node.setIcmMetricsFinished(true);
        }
    }
}

