/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import java.util.ArrayList;
import org.jfree.layouting.renderer.model.BoxLayoutProperties;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class ComputeMarginsStep
extends IterateVisualProcessStep {
    private long marginChangeKey;
    private ArrayList marginCollection;

    public void compute(LogicalPageBox root) {
        this.marginChangeKey = root.getChangeTracker();
        this.marginCollection = new ArrayList();
        this.startProcessing(root);
        this.marginChangeKey = 0L;
        this.marginCollection.clear();
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.startProcessing(box.getPool());
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        boolean infiniteMarginTop;
        BoxLayoutProperties blp = box.getBoxLayoutProperties();
        if (blp.getMarginOpenState() == this.marginChangeKey) {
            return true;
        }
        if (box instanceof TableRowRenderBox || box instanceof TableSectionRenderBox || box instanceof TableCellRenderBox) {
            blp.setMarginOpenState(this.marginChangeKey);
            return true;
        }
        RenderBox boxParent = box.getParent();
        RenderNode visiblePrev = box.getVisiblePrev();
        if (boxParent == null) {
            infiniteMarginTop = visiblePrev == null;
        } else {
            ComputedLayoutProperties sBlp = boxParent.getComputedLayoutProperties();
            BoxLayoutProperties pBlp = boxParent.getBoxLayoutProperties();
            infiniteMarginTop = pBlp.isInfiniteMarginTop() && visiblePrev == null && sBlp.getBorderTop() == 0L && sBlp.getPaddingTop() != 0L;
        }
        this.marginCollection.clear();
        RenderBox marginBox = box;
        while (true) {
            RenderNode node;
            this.marginCollection.add(marginBox);
            ComputedLayoutProperties cblp = marginBox.getComputedLayoutProperties();
            if (cblp.getBorderBottom() != 0L || cblp.getPaddingBottom() != 0L || !((node = marginBox.getVisibleFirst()) instanceof RenderBox)) break;
            marginBox = (RenderBox)node;
        }
        if (infiniteMarginTop) {
            for (int i = 0; i < this.marginCollection.size(); ++i) {
                RenderBox renderBox = (RenderBox)this.marginCollection.get(i);
                BoxLayoutProperties cblp = renderBox.getBoxLayoutProperties();
                cblp.setEffectiveMarginTop(0L);
                cblp.setInfiniteMarginTop(true);
                cblp.setMarginOpenState(this.marginChangeKey);
            }
            return true;
        }
        long topMarginPositive = 0L;
        long topMarginNegative = 0L;
        ComputedLayoutProperties sblp = box.getComputedLayoutProperties();
        long marginTop = sblp.getMarginTop();
        if (marginTop < 0L) {
            topMarginNegative = marginTop;
        } else {
            topMarginPositive = marginTop;
        }
        if (visiblePrev != null) {
            long effectiveMarginBottom = visiblePrev.getEffectiveMarginBottom();
            if (effectiveMarginBottom < 0L) {
                topMarginNegative = Math.min(topMarginNegative, effectiveMarginBottom);
            } else {
                topMarginPositive = Math.max(topMarginPositive, effectiveMarginBottom);
            }
        }
        for (int i = 1; i < this.marginCollection.size(); ++i) {
            RenderBox renderBox = (RenderBox)this.marginCollection.get(i);
            BoxLayoutProperties cblp = renderBox.getBoxLayoutProperties();
            ComputedLayoutProperties scblp = renderBox.getComputedLayoutProperties();
            long childMarginTop = scblp.getMarginTop();
            if (childMarginTop < 0L) {
                topMarginNegative = Math.min(topMarginNegative, childMarginTop);
            } else {
                topMarginPositive = Math.max(topMarginPositive, childMarginTop);
            }
            cblp.setMarginOpenState(this.marginChangeKey);
            cblp.setInfiniteMarginTop(false);
            cblp.setEffectiveMarginTop(0L);
        }
        long effectiveMargin = topMarginPositive + topMarginNegative;
        blp.setEffectiveMarginTop(effectiveMargin);
        blp.setInfiniteMarginTop(false);
        blp.setMarginOpenState(this.marginChangeKey);
        return true;
    }

    protected void finishBlockLevelBox(RenderBox box) {
        BoxLayoutProperties blp = box.getBoxLayoutProperties();
        if (blp.getMarginCloseState() == this.marginChangeKey) {
            return;
        }
        if (box instanceof TableCellRenderBox || box instanceof TableRowRenderBox || box instanceof TableSectionRenderBox) {
            blp.setMarginCloseState(this.marginChangeKey);
            return;
        }
        this.marginCollection.clear();
        RenderBox marginBox = box;
        while (true) {
            ComputedLayoutProperties sblp;
            RenderBox parent;
            this.marginCollection.add(marginBox);
            if (marginBox.getNext() != null || (parent = marginBox.getParent()) == null || (sblp = parent.getComputedLayoutProperties()).getBorderBottom() != 0L || sblp.getPaddingBottom() != 0L) break;
            marginBox = parent;
        }
        RenderBox lastBox = (RenderBox)this.marginCollection.get(this.marginCollection.size() - 1);
        if (lastBox.getParent() == null) {
            for (int i = 0; i < this.marginCollection.size(); ++i) {
                RenderBox renderBox = (RenderBox)this.marginCollection.get(i);
                BoxLayoutProperties cblp = renderBox.getBoxLayoutProperties();
                cblp.setMarginCloseState(this.marginChangeKey);
                cblp.setInfiniteMarginBottom(true);
                cblp.setEffectiveMarginBottom(0L);
            }
            return;
        }
        long marginNegative = 0L;
        long marginPositive = 0L;
        for (int i = 0; i < this.marginCollection.size(); ++i) {
            RenderBox renderBox = (RenderBox)this.marginCollection.get(i);
            BoxLayoutProperties cblp = renderBox.getBoxLayoutProperties();
            cblp.setMarginCloseState(this.marginChangeKey);
            cblp.setInfiniteMarginBottom(false);
            cblp.setEffectiveMarginBottom(0L);
            ComputedLayoutProperties sblp = renderBox.getComputedLayoutProperties();
            marginNegative = Math.min(marginNegative, sblp.getMarginBottom());
            marginPositive = Math.max(marginPositive, sblp.getMarginBottom());
        }
        BoxLayoutProperties lblp = lastBox.getBoxLayoutProperties();
        lblp.setEffectiveMarginBottom(marginPositive + marginNegative);
        lblp.setInfiniteMarginBottom(false);
        lblp.setMarginCloseState(this.marginChangeKey);
    }

    private boolean isCollapsibleTop(RenderNode node) {
        if (!(node instanceof RenderBox)) {
            return false;
        }
        RenderBox marginBox = (RenderBox)node;
        ComputedLayoutProperties blp = marginBox.getComputedLayoutProperties();
        if (blp.getBorderTop() != 0L) {
            return false;
        }
        return blp.getPaddingTop() == 0L;
    }
}

