/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.BorderEdge;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.StaticBoxLayoutProperties;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class ComputeStaticPropertiesStep
extends IterateVisualProcessStep {
    private LogicalPageBox root;

    public void compute(LogicalPageBox root) {
        this.root = root;
        this.startProcessing(root);
        this.root = null;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.startProcessing(box.getPool());
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        if (box.getComputedLayoutProperties() != null) {
            return true;
        }
        RenderLength bcw = this.computeBlockContextWidth(box);
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        long rbcw = bcw.resolve(0L);
        BoxDefinition boxDefinition = box.getBoxDefinition();
        ComputedLayoutProperties clp = new ComputedLayoutProperties();
        if (box instanceof TableCellRenderBox) {
            this.computeBorder(boxDefinition, clp, rbcw);
            RenderLength preferredWidth = boxDefinition.getPreferredWidth();
            if (preferredWidth == RenderLength.AUTO) {
                TableCellRenderBox cellBox = (TableCellRenderBox)box;
                TableColumnModel columnModel = cellBox.getTable().getColumnModel();
                int colIdx = cellBox.getColumnIndex();
                if (colIdx < 0) {
                    throw new IllegalStateException("Table has not been validated yet.");
                }
                int maxIdx = colIdx + cellBox.getColSpan();
                if (maxIdx >= columnModel.getColumnCount()) {
                    clp.setBlockContextWidth(bcw);
                    clp.setComputedWidth(RenderLength.AUTO);
                    box.setComputedLayoutProperties(clp);
                } else {
                    long width = 0L;
                    for (int i = colIdx; i < maxIdx; ++i) {
                        TableColumn column = columnModel.getColumn(i);
                        RenderLength definedWidth = column.getDefinedWidth();
                        if (definedWidth == RenderLength.AUTO) {
                            width = -1L;
                            break;
                        }
                        width += definedWidth.resolve(rbcw);
                    }
                    if (width > 0L) {
                        clp.setBlockContextWidth(bcw);
                        clp.setComputedWidth(new RenderLength(width, false));
                        box.setComputedLayoutProperties(clp);
                    } else {
                        clp.setBlockContextWidth(bcw);
                        clp.setComputedWidth(RenderLength.AUTO);
                        box.setComputedLayoutProperties(clp);
                    }
                }
            } else {
                clp.setBlockContextWidth(bcw);
                clp.setComputedWidth(preferredWidth.resolveToRenderLength(rbcw));
                box.setComputedLayoutProperties(clp);
            }
            return true;
        }
        if (box instanceof TableRowRenderBox || box instanceof TableSectionRenderBox) {
            clp.setBlockContextWidth(bcw);
            clp.setComputedWidth(bcw);
            box.setComputedLayoutProperties(clp);
            return true;
        }
        this.computeBorder(boxDefinition, clp, rbcw);
        clp.setMarginTop(boxDefinition.getMarginTop().resolve(rbcw));
        clp.setMarginBottom(boxDefinition.getMarginBottom().resolve(rbcw));
        RenderLength marginLeft = boxDefinition.getMarginLeft();
        RenderLength marginRight = boxDefinition.getMarginRight();
        RenderLength preferredWidth = boxDefinition.getPreferredWidth();
        if (preferredWidth != RenderLength.AUTO) {
            if (marginLeft != RenderLength.AUTO && marginRight != RenderLength.AUTO) {
                long pwValue;
                long mrValue;
                long mlValue = marginLeft.resolve(rbcw);
                if (mlValue + (mrValue = marginRight.resolve(rbcw)) + (pwValue = preferredWidth.resolve(rbcw)) == rbcw) {
                    clp.setMarginLeft(mlValue);
                    clp.setMarginRight(mrValue);
                } else if (box.isDirectionLTR()) {
                    clp.setMarginLeft(mlValue);
                    clp.setMarginRight(rbcw - mlValue - pwValue);
                } else {
                    clp.setMarginLeft(rbcw - mrValue - pwValue);
                    clp.setMarginRight(mrValue);
                }
                clp.setBlockContextWidth(bcw);
                clp.setComputedWidth(new RenderLength(pwValue, false));
                box.setComputedLayoutProperties(clp);
                return true;
            }
            if (marginLeft == RenderLength.AUTO && marginRight != RenderLength.AUTO) {
                long mrValue = marginRight.resolve(rbcw);
                long pwValue = preferredWidth.resolve(rbcw);
                clp.setMarginLeft(rbcw - mrValue - pwValue);
                clp.setMarginRight(mrValue);
                clp.setBlockContextWidth(bcw);
                clp.setComputedWidth(new RenderLength(pwValue, false));
                box.setComputedLayoutProperties(clp);
                return true;
            }
            if (marginLeft != RenderLength.AUTO && marginRight == RenderLength.AUTO) {
                long mlValue = marginLeft.resolve(rbcw);
                long pwValue = preferredWidth.resolve(rbcw);
                clp.setMarginLeft(mlValue);
                clp.setMarginRight(rbcw - mlValue - pwValue);
                clp.setBlockContextWidth(bcw);
                clp.setComputedWidth(new RenderLength(pwValue, false));
                box.setComputedLayoutProperties(clp);
                return true;
            }
        } else {
            long mlValue = marginLeft.resolve(rbcw);
            long mrValue = marginRight.resolve(rbcw);
            clp.setMarginLeft(mlValue);
            clp.setMarginRight(mrValue);
            if (box instanceof TableRenderBox) {
                clp.setBlockContextWidth(bcw);
                clp.setComputedWidth(RenderLength.AUTO);
                box.setComputedLayoutProperties(clp);
            } else if (bcw == RenderLength.AUTO) {
                clp.setBlockContextWidth(bcw);
                clp.setComputedWidth(RenderLength.AUTO);
                box.setComputedLayoutProperties(clp);
            } else {
                clp.setBlockContextWidth(bcw);
                clp.setComputedWidth(new RenderLength(rbcw - mlValue - mrValue, false));
                box.setComputedLayoutProperties(clp);
            }
            return true;
        }
        long pwValue = preferredWidth.resolve(rbcw);
        long margins = rbcw - pwValue;
        long mlValue = margins / 2L;
        clp.setMarginLeft(mlValue);
        clp.setMarginRight(margins - mlValue);
        clp.setBlockContextWidth(bcw);
        clp.setComputedWidth(new RenderLength(pwValue, false));
        box.setComputedLayoutProperties(clp);
        return true;
    }

    protected void processBlockLevelNode(RenderNode node) {
        RenderLength bcw = this.computeBlockContextWidth(node);
        ComputedLayoutProperties clp = new ComputedLayoutProperties();
        clp.setBlockContextWidth(bcw);
        clp.setComputedWidth(RenderLength.AUTO);
        node.setComputedLayoutProperties(clp);
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        if (box.getComputedLayoutProperties() != null) {
            return true;
        }
        RenderLength bcw = this.computeBlockContextWidth(box);
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        long rbcw = bcw.resolve(0L);
        BoxDefinition boxDefinition = box.getBoxDefinition();
        ComputedLayoutProperties clp = new ComputedLayoutProperties();
        this.computeBorder(boxDefinition, clp, rbcw);
        clp.setMarginTop(0L);
        clp.setMarginBottom(0L);
        clp.setMarginLeft(boxDefinition.getMarginLeft().resolve(rbcw));
        clp.setMarginRight(boxDefinition.getMarginRight().resolve(rbcw));
        clp.setBlockContextWidth(bcw);
        clp.setComputedWidth(RenderLength.AUTO);
        box.setComputedLayoutProperties(clp);
        return true;
    }

    protected void processInlineLevelNode(RenderNode node) {
        if (node.getComputedLayoutProperties() != null) {
            return;
        }
        RenderLength bcw = this.computeBlockContextWidth(node);
        ComputedLayoutProperties clp = new ComputedLayoutProperties();
        clp.setBlockContextWidth(bcw);
        clp.setComputedWidth(RenderLength.AUTO);
        node.setComputedLayoutProperties(clp);
    }

    private void computeBorder(BoxDefinition boxDefinition, ComputedLayoutProperties slp, long bcw) {
        Border border = boxDefinition.getBorder();
        slp.setBorderTop(this.resolveBorderEdge(bcw, border.getTop()));
        slp.setBorderLeft(this.resolveBorderEdge(bcw, border.getLeft()));
        slp.setBorderBottom(this.resolveBorderEdge(bcw, border.getBottom()));
        slp.setBorderRight(this.resolveBorderEdge(bcw, border.getRight()));
        slp.setPaddingTop(boxDefinition.getPaddingTop().resolve(bcw));
        slp.setPaddingLeft(boxDefinition.getPaddingLeft().resolve(bcw));
        slp.setPaddingBottom(boxDefinition.getPaddingBottom().resolve(bcw));
        slp.setPaddingRight(boxDefinition.getPaddingRight().resolve(bcw));
    }

    protected RenderLength computeBlockContextWidth(RenderNode node) {
        RenderBox blockContext = node.getParentBlockContext();
        if (blockContext == null) {
            return new RenderLength(this.root.getPageWidth(), false);
        }
        ComputedLayoutProperties layoutProperties = blockContext.getComputedLayoutProperties();
        return layoutProperties.getComputedWidth();
    }

    private long resolveBorderEdge(long bcw, BorderEdge borderEdge) {
        if (BorderStyle.NONE.equals(borderEdge.getBorderStyle())) {
            return 0L;
        }
        return borderEdge.getWidth().resolve(bcw);
    }
}

