/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cells.DataCell;
import org.jfree.layouting.renderer.model.table.cells.TableCell;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.model.table.rows.TableRow;
import org.jfree.layouting.renderer.model.table.rows.TableRowModel;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.jfree.util.FastStack;

public class ComputeTableICMMetricsStep
extends IterateStructuralProcessStep {
    private FastStack tableStack = new FastStack();
    private TableInfoStructure currentTable;

    public void compute(LogicalPageBox root) {
        this.startProcessing(root);
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        if (box instanceof TableRenderBox) {
            TableRenderBox table = (TableRenderBox)box;
            this.currentTable = new TableInfoStructure(table);
            this.tableStack.push((Object)this.currentTable);
        } else if (box instanceof TableSectionRenderBox) {
            TableSectionRenderBox sectionBox = (TableSectionRenderBox)box;
            this.currentTable.setRowModel(sectionBox.getRowModel());
        }
        return true;
    }

    protected void finishBlockBox(BlockRenderBox box) {
        if (box instanceof TableRowRenderBox) {
            this.finishTableRow((TableRowRenderBox)box);
        } else if (box instanceof TableRenderBox) {
            this.finishTable((TableRenderBox)box);
        } else if (box instanceof TableSectionRenderBox) {
            this.currentTable.setRowModel(null);
        }
    }

    private void finishTable(TableRenderBox box) {
        box.getColumnModel().validateSizes(box);
        this.tableStack.pop();
        this.currentTable = !this.tableStack.isEmpty() ? (TableInfoStructure)this.tableStack.peek() : null;
    }

    private void finishTableRow(TableRowRenderBox box) {
        TableRenderBox table = this.currentTable.getTable();
        TableColumnModel columnModel = table.getColumnModel();
        TableSectionRenderBox section = (TableSectionRenderBox)box.getParent();
        TableRowModel rowModel = section.getRowModel();
        TableRowInfoStructure rowInfoStructure = box.getRowInfoStructure();
        int rowNumber = this.currentTable.getRowNumber();
        rowInfoStructure.setRowNumber(rowNumber);
        TableRow row = rowModel.getRow(rowNumber);
        BoxDefinition boxDefinition = box.getBoxDefinition();
        RenderLength preferredHeight = boxDefinition.getPreferredHeight();
        ComputedLayoutProperties rowNlp = box.getComputedLayoutProperties();
        RenderLength rowComputedWidth = rowNlp.getComputedWidth();
        row.clearSizes();
        row.setPreferredSize(preferredHeight.resolve(rowComputedWidth.resolve(0L)));
        int cellCount = rowInfoStructure.getCellCount();
        for (int i = 0; i < cellCount; ++i) {
            TableCell cellAt = rowInfoStructure.getCellAt(i);
            if (!(cellAt instanceof DataCell)) continue;
            DataCell dataCell = (DataCell)cellAt;
            RenderNode cell = this.findCellInRow(box, dataCell.getCellRenderBox());
            if (cell == null) {
                throw new IllegalStateException("No such cell: " + dataCell.getCellRenderBox());
            }
            TableColumn column = columnModel.getColumn(i);
            int colSpan = dataCell.getColSpan();
            column.updateMinimumChunkSize(colSpan, cell.getMinimumChunkWidth());
            column.updateMaxBoxSize(colSpan, cell.getMaximumBoxWidth());
            RenderLength computedWidth = cell.getComputedLayoutProperties().getComputedWidth();
            if (!(computedWidth == RenderLength.AUTO)) {
                column.updatePreferredSize(colSpan, computedWidth.getValue());
            }
            RenderLength definedHeight = box.getBoxDefinition().getPreferredHeight();
            row.updateDefinedSize(dataCell.getRowSpan(), definedHeight.resolve(computedWidth.resolve(0L)));
        }
        this.currentTable.increaseRowNumber();
    }

    private RenderNode findCellInRow(TableRowRenderBox box, Object instanceId) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            if (node.getInstanceId() != instanceId) continue;
            return node;
        }
        return null;
    }

    public static class TableInfoStructure {
        private TableRenderBox table;
        private TableColumnModel columnModel;
        private TableRowModel rowModel;
        private int rowNumber;

        public TableInfoStructure(TableRenderBox table) {
            this.table = table;
            this.columnModel = table.getColumnModel();
        }

        public TableRenderBox getTable() {
            return this.table;
        }

        public TableColumnModel getColumnModel() {
            return this.columnModel;
        }

        public TableRowModel getRowModel() {
            return this.rowModel;
        }

        public void setRowModel(TableRowModel rowModel) {
            this.rowModel = rowModel;
            this.rowNumber = 0;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public void increaseRowNumber() {
            ++this.rowNumber;
        }
    }
}

