/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.process.AbstractAlignmentProcessor;
import org.jfree.layouting.renderer.process.layoutrules.EndSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineNodeSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.StartSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.TextSequenceElement;

public class LeftAlignmentProcessor
extends AbstractAlignmentProcessor {
    private long position;
    private int pageSegment;

    public int getPageSegment() {
        return this.pageSegment;
    }

    public void setPageSegment(int pageSegment) {
        this.pageSegment = pageSegment;
    }

    protected long getPosition() {
        return this.position;
    }

    protected void setPosition(long position) {
        this.position = position;
    }

    protected void addPosition(long width) {
        this.position += width;
    }

    public RenderNode next() {
        this.position = this.getStartOfLine();
        this.pageSegment = 0;
        RenderNode retval = super.next();
        this.position = 0L;
        this.pageSegment = 0;
        return retval;
    }

    protected int handleElement(int start, int count) {
        long elementWidth;
        InlineSequenceElement element;
        int i;
        long pagebreak;
        InlineSequenceElement[] sequenceElements = this.getSequenceElements();
        long[] elementDimensions = this.getElementDimensions();
        long[] elementPositions = this.getElementPositions();
        long width = 0L;
        int endIndex = start + count;
        InlineSequenceElement contentElement = null;
        int contentIndex = start;
        for (int i2 = start; i2 < endIndex; ++i2) {
            InlineSequenceElement element2 = sequenceElements[i2];
            width += element2.getMaximumWidth();
            if (element2 instanceof StartSequenceElement || element2 instanceof EndSequenceElement) continue;
            contentElement = element2;
            contentIndex = i2;
        }
        long nextPosition = this.getPosition() + width;
        if (nextPosition > (pagebreak = this.getPageBreak(this.getPageSegment()))) {
            long position = this.getPosition();
            for (int i3 = start; i3 < endIndex; ++i3) {
                long elementWidth2;
                InlineSequenceElement element3 = sequenceElements[i3];
                elementPositions[i3] = position;
                elementDimensions[i3] = elementWidth2 = element3.getMaximumWidth();
                position += elementWidth2;
            }
            if (contentElement instanceof TextSequenceElement) {
                this.setSkipIndex(endIndex);
                this.setBreakableIndex(contentIndex);
                return start;
            }
            if (start == 0) {
                RenderNode node;
                if (contentElement instanceof InlineNodeSequenceElement && (node = contentElement.getNode()) instanceof RenderBox) {
                    RenderBox box = (RenderBox)node;
                    long maxWidth = this.getEndOfLine() - this.getPosition();
                    this.computeInlineBlock(box, this.getPosition(), maxWidth);
                    elementDimensions[endIndex - 1] = node.getWidth();
                }
                this.setSkipIndex(endIndex);
            }
            return start;
        }
        if (!(contentElement instanceof InlineNodeSequenceElement)) {
            for (int i4 = start; i4 < endIndex; ++i4) {
                long elementWidth3;
                InlineSequenceElement element4 = sequenceElements[i4];
                elementPositions[i4] = this.getPosition();
                elementDimensions[i4] = elementWidth3 = element4.getMaximumWidth();
                this.addPosition(elementWidth3);
            }
            return endIndex;
        }
        long itemElementWidth = contentElement.getMaximumWidth();
        RenderNode node = contentElement.getNode();
        if (node instanceof RenderBox) {
            RenderBox box = (RenderBox)node;
            this.computeInlineBlock(box, this.getPosition(), itemElementWidth);
        } else {
            node.setX(this.getPosition());
            node.setWidth(itemElementWidth);
        }
        long preferredEndingPos = this.getPosition() + itemElementWidth;
        if (preferredEndingPos > this.getEndOfLine()) {
            if (start == 0) {
                return endIndex;
            }
            return start;
        }
        for (i = start; i < contentIndex; ++i) {
            element = sequenceElements[i];
            elementWidth = element.getMaximumWidth();
            elementPositions[i] = this.getPosition();
            elementDimensions[i] = elementWidth;
            this.addPosition(elementWidth);
        }
        elementPositions[contentIndex] = this.getPosition();
        elementDimensions[contentIndex] = itemElementWidth;
        this.setPosition(preferredEndingPos);
        for (i = contentIndex + 1; i < endIndex; ++i) {
            element = sequenceElements[i];
            elementWidth = element.getMaximumWidth();
            elementPositions[i] = this.getPosition();
            elementDimensions[i] = elementWidth;
            this.addPosition(elementWidth);
        }
        return endIndex;
    }

    protected int handleLayout(int start, int count, int contentIndex, long usedWidth) {
        return 0;
    }
}

