/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.renderer.model.PageAreaRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableColumnGroupNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.process.BoxShifter;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class PaginationStep
extends IterateVisualProcessStep {
    private long pageStartOffset;
    private boolean pageOverflow;
    private long shift;
    private long[] physicalBreaks;
    private long headerHeight;
    private long footerHeight;
    private long stickyMarker;
    private BoxShifter boxShifter = new BoxShifter();

    public boolean performPagebreak(LogicalPageBox pageBox) {
        this.pageStartOffset = 0L;
        this.pageOverflow = false;
        this.shift = 0L;
        this.physicalBreaks = null;
        this.headerHeight = 0L;
        this.footerHeight = 0L;
        this.stickyMarker = 0L;
        this.pageStartOffset = pageBox.getPageOffset();
        this.pageOverflow = false;
        this.stickyMarker = pageBox.getChangeTracker();
        this.shift = 0L;
        this.startRootProcessing(pageBox);
        return this.pageOverflow;
    }

    public long getNextOffset() {
        return this.physicalBreaks[this.physicalBreaks.length - 1];
    }

    private boolean isCrossingBreak(RenderNode node) {
        int y1Index = -1;
        int y2Index = -1;
        long nodeY1 = node.getY() + this.shift;
        long nodeY2 = nodeY1 + node.getHeight();
        for (int i = 0; i < this.physicalBreaks.length; ++i) {
            long physicalBreak = this.physicalBreaks[i];
            if (nodeY1 >= physicalBreak) {
                y1Index = i;
            }
            if (nodeY2 < physicalBreak) continue;
            y2Index = i;
        }
        return y1Index != y2Index;
    }

    private void startRootProcessing(LogicalPageBox pageBox) {
        PageAreaRenderBox headerArea = pageBox.getHeaderArea();
        this.headerHeight = headerArea.getHeight();
        headerArea.setHeight(this.headerHeight);
        PageAreaRenderBox footerArea = pageBox.getFooterArea();
        this.footerHeight = footerArea.getHeight();
        footerArea.setHeight(this.footerHeight);
        long[] originalBreaks = pageBox.getPhysicalBreaks(1);
        this.physicalBreaks = new long[originalBreaks.length + 1];
        this.physicalBreaks[0] = this.pageStartOffset;
        for (int i = 0; i < originalBreaks.length; ++i) {
            this.physicalBreaks[i + 1] = this.pageStartOffset + (originalBreaks[i] - this.headerHeight);
        }
        int n = this.physicalBreaks.length - 1;
        this.physicalBreaks[n] = this.physicalBreaks[n] - this.footerHeight;
        long totalPageHeight = this.physicalBreaks[this.physicalBreaks.length - 1] - this.physicalBreaks[0];
        if (totalPageHeight + this.headerHeight + this.footerHeight != pageBox.getPageHeight()) {
            throw new IllegalStateException("Assertation failed: Page height");
        }
        if (this.startBlockLevelBox(pageBox)) {
            this.processBoxChilds(pageBox);
        }
        this.finishBlockLevelBox(pageBox);
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        return false;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        for (RenderNode node = box.getVisibleFirst(); node != null; node = node.getVisibleNext()) {
            if (!(node instanceof ParagraphPoolBox)) {
                throw new IllegalStateException("Encountered " + node.getClass());
            }
            ParagraphPoolBox inlineRenderBox = (ParagraphPoolBox)node;
            if (this.startLine(inlineRenderBox)) {
                this.processBoxChilds(inlineRenderBox);
            }
            this.finishLine(inlineRenderBox);
        }
    }

    private boolean isNodeProcessable(RenderNode node) {
        if (node.getStickyMarker() == this.stickyMarker) {
            return false;
        }
        long y2 = node.getY() + node.getHeight();
        if (y2 < this.pageStartOffset) {
            return false;
        }
        return !node.isIgnorableForRendering();
    }

    protected void processBlockLevelNode(RenderNode node) {
        if (!this.isNodeProcessable(node)) {
            return;
        }
        node.setY(node.getY() + this.shift);
        if (!this.isCrossingBreak(node)) {
            return;
        }
        long nextBreakShiftDistance = this.getNextBreak(node.getY()) - node.getY();
        node.setY(node.getY() + nextBreakShiftDistance);
        this.boxShifter.extendHeight(node, nextBreakShiftDistance);
        this.shift += nextBreakShiftDistance;
        node.setStickyMarker(this.stickyMarker);
    }

    protected void processTable(TableRenderBox table) {
        long originalShift = this.shift;
        long height = table.getHeight();
        long y = table.getY();
        long y2 = this.shift + y + height;
        if (y2 < this.pageStartOffset) {
            return;
        }
        if (table.isIgnorableForRendering()) {
            return;
        }
        long nextBreak = this.getNextBreak(y + this.shift);
        long usableHeight = nextBreak - (y + this.shift);
        if (usableHeight > 0L) {
            long reservedHeight = Math.min(height, table.getOrphansSize() + table.getWidowsSize());
            if (table.isAvoidPagebreakInside() || reservedHeight > usableHeight || table.getOrphansSize() > usableHeight) {
                long newShift = nextBreak - y;
                if (newShift > 0L) {
                    table.setY(table.getY() + newShift);
                    this.boxShifter.extendHeight(table.getParent(), newShift - this.shift);
                    this.shift = newShift;
                    table.setStickyMarker(this.stickyMarker);
                } else if (newShift < 0L) {
                    table.setY(table.getY() + this.shift);
                    this.pageOverflow = true;
                }
            } else {
                table.setY(table.getY() + this.shift);
                table.setStickyMarker(this.stickyMarker);
            }
        } else {
            table.setY(table.getY() + this.shift);
            table.setStickyMarker(this.stickyMarker);
        }
        this.processTableSection(table, DisplayRole.TABLE_HEADER_GROUP);
        this.processTableSection(table, DisplayRole.TABLE_ROW_GROUP);
        this.processTableSection(table, DisplayRole.TABLE_FOOTER_GROUP);
        long finalHeight = table.getHeight();
        long delta = finalHeight - height;
        if (delta < 0L) {
            throw new IllegalStateException("A table can/must not shrink!");
        }
    }

    private void processTableSection(TableRenderBox box, CSSConstant role) {
        RenderNode rowGroupNode = box.getFirstChild();
        while (rowGroupNode != null) {
            if (!(rowGroupNode instanceof TableSectionRenderBox)) {
                rowGroupNode = rowGroupNode.getNext();
                continue;
            }
            TableSectionRenderBox sectionBox = (TableSectionRenderBox)rowGroupNode;
            if (!role.equals(sectionBox.getDisplayRole())) {
                rowGroupNode = rowGroupNode.getNext();
                continue;
            }
            this.startProcessing(rowGroupNode);
            rowGroupNode = rowGroupNode.getNext();
        }
    }

    protected void processBlockLevelChild(RenderNode node) {
        if (node instanceof TableRenderBox) {
            TableRenderBox table = (TableRenderBox)node;
            this.processTable(table);
        } else {
            super.processBlockLevelChild(node);
        }
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        if (!this.isNodeProcessable(box)) {
            return false;
        }
        long y = box.getY();
        if (box instanceof TableCellRenderBox) {
            box.setY(y + this.shift);
            box.setStickyMarker(this.stickyMarker);
            return true;
        }
        if (this.isOverflow(box)) {
            this.pageOverflow = true;
            this.boxShifter.shiftBox(box, this.shift);
            return false;
        }
        if (!this.isCrossingBreak(box)) {
            this.boxShifter.shiftBox(box, this.shift);
            return false;
        }
        if (box instanceof TableColumnGroupNode) {
            throw new IllegalArgumentException("This is not expected here");
        }
        long nextBreak = this.getNextBreak(y + this.shift);
        long usableHeight = nextBreak - (y + this.shift);
        long height = box.getHeight();
        long reservedHeight = Math.min(height, box.getOrphansSize() + box.getWidowsSize());
        if (box.isAvoidPagebreakInside() || usableHeight < 0L || reservedHeight > height || box.getOrphansSize() > usableHeight) {
            long newShift = nextBreak - y;
            if (newShift > 0L) {
                this.boxShifter.shiftBox(box, newShift);
                this.boxShifter.extendHeight(box.getParent(), newShift - this.shift);
                this.shift = newShift;
                box.setStickyMarker(this.stickyMarker);
                return false;
            }
            if (newShift < 0L) {
                this.boxShifter.shiftBox(box, this.shift);
                this.pageOverflow = true;
                return false;
            }
            return false;
        }
        box.setY(box.getY() + this.shift);
        box.setStickyMarker(this.stickyMarker);
        return true;
    }

    private boolean isOverflow(RenderNode box) {
        long lastBreak = this.physicalBreaks[this.physicalBreaks.length - 1];
        return box.getY() + this.shift > lastBreak;
    }

    private long getNextBreak(long y) {
        for (int i = 0; i < this.physicalBreaks.length; ++i) {
            long physicalBreak = this.physicalBreaks[i];
            if (y >= physicalBreak) continue;
            return physicalBreak;
        }
        return this.physicalBreaks[this.physicalBreaks.length - 1];
    }

    protected boolean startLine(ParagraphPoolBox box) {
        if (!this.isNodeProcessable(box)) {
            return false;
        }
        if (this.isOverflow(box)) {
            this.boxShifter.shiftBox(box, this.shift);
            this.pageOverflow = true;
            return false;
        }
        long nextBreak = this.getNextBreak(box.getY() + this.shift);
        long usableHeight = nextBreak - (box.getY() + this.shift);
        if (box.getHeight() < usableHeight) {
            this.boxShifter.shiftBox(box, this.shift);
            box.setStickyMarker(this.stickyMarker);
            return false;
        }
        long newShift = nextBreak - box.getY();
        if (newShift > 0L) {
            this.boxShifter.shiftBox(box, newShift);
            this.boxShifter.extendHeight(box, newShift - this.shift);
            this.shift = newShift;
            box.setStickyMarker(this.stickyMarker);
        } else if (newShift < 0L) {
            this.pageOverflow = true;
            this.boxShifter.shiftBox(box, this.shift);
        } else {
            this.boxShifter.shiftBox(box, this.shift);
        }
        return false;
    }

    protected void finishLine(ParagraphPoolBox inlineRenderBox) {
    }
}

