/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import java.util.ArrayList;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.process.layoutrules.InlineNodeSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.TextSequenceElement;

public class ParagraphBreakState {
    private Object suspendItem;
    private ArrayList primarySequence;
    private ParagraphRenderBox paragraph;
    private boolean containsContent;

    public ParagraphBreakState(ParagraphRenderBox paragraph) {
        if (paragraph == null) {
            throw new NullPointerException();
        }
        this.paragraph = paragraph;
        this.primarySequence = new ArrayList();
    }

    public ParagraphRenderBox getParagraph() {
        return this.paragraph;
    }

    public Object getSuspendItem() {
        return this.suspendItem;
    }

    public void setSuspendItem(Object suspendItem) {
        this.suspendItem = suspendItem;
    }

    public void add(InlineSequenceElement element) {
        this.primarySequence.add(element);
        if (element instanceof TextSequenceElement || element instanceof InlineNodeSequenceElement) {
            this.containsContent = true;
        }
    }

    public boolean isContainsContent() {
        return this.containsContent;
    }

    public boolean isSuspended() {
        return this.suspendItem != null;
    }

    public InlineSequenceElement[] getSequence() {
        return this.primarySequence.toArray(new InlineSequenceElement[this.primarySequence.size()]);
    }

    public void clear() {
        this.primarySequence.clear();
        this.containsContent = false;
    }
}

