/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.EmptyBoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableColumnGroupNode;
import org.jfree.layouting.renderer.model.table.TableColumnNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cells.ConflictingCell;
import org.jfree.layouting.renderer.model.table.cells.DataCell;
import org.jfree.layouting.renderer.model.table.cells.PlaceHolderCell;
import org.jfree.layouting.renderer.model.table.cells.TableCell;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnGroup;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.model.table.rows.TableRow;
import org.jfree.layouting.renderer.model.table.rows.TableRowModel;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.jfree.util.FastStack;

public class TableValidationStep
extends IterateStructuralProcessStep {
    private FastStack tableStack = new FastStack();
    private TableInfoStructure currentTable;

    public void validate(LogicalPageBox box) {
        this.tableStack.clear();
        this.currentTable = null;
        this.startProcessing(box);
        if (!this.tableStack.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        if (!(box instanceof TableRenderBox)) {
            return true;
        }
        TableRenderBox table = (TableRenderBox)box;
        this.currentTable = new TableInfoStructure(table);
        this.tableStack.push((Object)this.currentTable);
        if (!table.isOpen()) {
            if (!table.isStructureValidated()) {
                this.validateTable();
                return true;
            }
            return false;
        }
        this.validateTable();
        return true;
    }

    protected void finishBlockBox(BlockRenderBox box) {
        if (box instanceof TableRenderBox) {
            this.currentTable = (TableInfoStructure)this.tableStack.pop();
        }
    }

    private void validateTable() {
        this.validatePredefinedColumns();
        this.validateRowStructure();
        TableRenderBox table = this.currentTable.getTable();
        if (!table.isOpen()) {
            table.setStructureValidated(true);
        }
    }

    private void validateFinalRows(TableSectionRenderBox section) {
        RenderBox lastRow = null;
        for (RenderNode rowNode = section.getLastChild(); rowNode != null; rowNode = rowNode.getVisiblePrev()) {
            if (!(rowNode instanceof TableRowRenderBox)) continue;
            lastRow = (TableRowRenderBox)rowNode;
            break;
        }
        TableRowModel rowModel = section.getRowModel();
        while (lastRow != null) {
            RenderBox autoGeneratedRow = null;
            TableRowInfoStructure autoRowInfo = null;
            TableRowInfoStructure rowInfo = lastRow.getRowInfoStructure();
            for (int i = 0; i < rowInfo.getCellCount(); ++i) {
                TableCell cell = rowInfo.getCellAt(i);
                if (cell.getRowSpan() > 1) {
                    PlaceHolderCell placeHolder;
                    if (autoGeneratedRow == null) {
                        autoGeneratedRow = new TableRowRenderBox(EmptyBoxDefinition.getInstance(), true);
                        rowModel.addRow(new TableRow());
                        autoRowInfo = ((TableRowRenderBox)autoGeneratedRow).getRowInfoStructure();
                        for (int emptyCellCnt = 0; emptyCellCnt < i; ++emptyCellCnt) {
                            TableCellRenderBox autoCell = new TableCellRenderBox(EmptyBoxDefinition.getInstance(), true);
                            autoCell.close();
                            autoCell.setColumnIndex(emptyCellCnt);
                            DataCell dataCell = new DataCell(1, 1, autoCell.getInstanceId());
                            autoRowInfo.addCell(dataCell);
                            autoGeneratedRow.addChild(autoCell);
                        }
                    }
                    if (cell instanceof DataCell) {
                        placeHolder = new PlaceHolderCell((DataCell)cell, cell.getRowSpan() - 1, cell.getColSpan());
                    } else if (cell instanceof PlaceHolderCell) {
                        PlaceHolderCell prevCell = (PlaceHolderCell)cell;
                        placeHolder = new PlaceHolderCell(prevCell.getSourceCell(), cell.getRowSpan() - 1, cell.getColSpan());
                    } else {
                        throw new IllegalStateException("Unexpected cell type.");
                    }
                    autoRowInfo.addCell(placeHolder);
                    continue;
                }
                if (autoGeneratedRow == null) continue;
                TableCellRenderBox autoCell = new TableCellRenderBox(EmptyBoxDefinition.getInstance(), true);
                autoCell.close();
                autoCell.setColumnIndex(i);
                DataCell dataCell = new DataCell(1, 1, autoCell.getInstanceId());
                autoRowInfo.addCell(dataCell);
                autoGeneratedRow.addChild(autoCell);
            }
            if (autoGeneratedRow != null) {
                autoGeneratedRow.close();
                autoRowInfo.setValidationDone(true);
                section.addGeneratedChild(autoGeneratedRow);
            }
            lastRow = autoGeneratedRow;
        }
    }

    private void validateRowStructure() {
        TableRenderBox table = this.currentTable.getTable();
        if (!table.isPredefinedColumnsValidated()) {
            return;
        }
        TableColumnModel columnModel = this.currentTable.getColumnModel();
        RenderNode node = table.getFirstChild();
        while (node != null) {
            if (!(node instanceof TableSectionRenderBox)) {
                node = node.getNext();
                continue;
            }
            TableSectionRenderBox section = (TableSectionRenderBox)node;
            if (!section.isStructureValidated()) {
                TableRowInfoStructure prevInfoStruct = new TableRowInfoStructure();
                RenderNode rowNode = section.getFirstChild();
                while (rowNode != null) {
                    if (rowNode.isOpen()) {
                        throw new IllegalStateException("An open row cannot be part of a layoutable model.");
                    }
                    if (!(rowNode instanceof TableRowRenderBox)) {
                        rowNode = rowNode.getNext();
                        continue;
                    }
                    TableRowInfoStructure infoStruct = this.validateRow(section, rowNode, prevInfoStruct);
                    int cellCount = infoStruct.getCellCount();
                    if (this.currentTable.getColumns() < cellCount) {
                        this.currentTable.setColumns(cellCount);
                    }
                    while (cellCount > columnModel.getColumnCount()) {
                        columnModel.addAutoColumn();
                    }
                    rowNode = rowNode.getNext();
                    prevInfoStruct = infoStruct;
                }
                if (!section.isOpen()) {
                    this.validateFinalRows(section);
                    section.setStructureValidated(true);
                }
            }
            node = node.getNext();
        }
    }

    private TableRowInfoStructure validateRow(TableSectionRenderBox section, RenderNode rowNode, TableRowInfoStructure prevInfoStruct) {
        TableRowRenderBox rowBox = (TableRowRenderBox)rowNode;
        TableRowInfoStructure infoStruct = rowBox.getRowInfoStructure();
        if (infoStruct.isValidationDone()) {
            return infoStruct;
        }
        RenderNode cellNode = rowBox.getFirstChild();
        int cellPosition = 0;
        while (cellNode != null) {
            if (!(cellNode instanceof TableCellRenderBox)) {
                cellNode = cellNode.getNext();
                continue;
            }
            TableCellRenderBox cellBox = (TableCellRenderBox)cellNode;
            if (cellPosition >= prevInfoStruct.getCellCount()) {
                cellBox.setColumnIndex(cellPosition);
                cellPosition = this.validateSafeCellPos(cellBox, infoStruct, cellPosition);
            } else {
                cellPosition = this.findCellPosition(cellPosition, prevInfoStruct, infoStruct);
                int colSpan = cellBox.getColSpan();
                int rowSpan = cellBox.getRowSpan();
                DataCell dataCell = new DataCell(rowSpan, colSpan, cellBox.getInstanceId());
                infoStruct.addCell(dataCell);
                cellBox.setColumnIndex(cellPosition);
                ++cellPosition;
                for (int i = 1; i < colSpan; ++i) {
                    if (cellPosition < prevInfoStruct.getCellCount()) {
                        TableCell prevCell = prevInfoStruct.getCellAt(cellPosition);
                        if (prevCell.getRowSpan() > 1) {
                            ConflictingCell conflictingCell = new ConflictingCell(dataCell, rowSpan, colSpan - i);
                            if (prevCell instanceof ConflictingCell) {
                                ConflictingCell prevConflictCell = (ConflictingCell)prevCell;
                                int count = prevConflictCell.getConflictingCellCount();
                                for (int x = 0; x < count; ++x) {
                                    PlaceHolderCell phc = prevConflictCell.getConflictingCell(x);
                                    if (phc.getRowSpan() <= 1) continue;
                                    PlaceHolderCell placeHolderCell = new PlaceHolderCell(phc.getSourceCell(), phc.getRowSpan() - 1, phc.getColSpan());
                                    conflictingCell.addConflictingCell(placeHolderCell);
                                }
                            } else if (prevCell instanceof PlaceHolderCell) {
                                PlaceHolderCell prevPHCell = (PlaceHolderCell)prevCell;
                                PlaceHolderCell placeHolderCell = new PlaceHolderCell(prevPHCell.getSourceCell(), prevCell.getRowSpan() - 1, prevCell.getColSpan());
                                conflictingCell.addConflictingCell(placeHolderCell);
                            } else if (prevCell instanceof DataCell) {
                                PlaceHolderCell placeHolderCell = new PlaceHolderCell((DataCell)prevCell, prevCell.getRowSpan() - 1, prevCell.getColSpan());
                                conflictingCell.addConflictingCell(placeHolderCell);
                            } else {
                                throw new IllegalStateException("Unexpected cell type.");
                            }
                            infoStruct.addCell(conflictingCell);
                        } else {
                            PlaceHolderCell placeHolderCell = new PlaceHolderCell(dataCell, rowSpan, colSpan - i);
                            infoStruct.addCell(placeHolderCell);
                        }
                    } else {
                        PlaceHolderCell placeHolderCell = new PlaceHolderCell(dataCell, rowSpan, colSpan - i);
                        infoStruct.addCell(placeHolderCell);
                    }
                    ++cellPosition;
                }
            }
            cellNode = cellNode.getNext();
        }
        TableRow row = new TableRow(rowBox.getBorder());
        section.getRowModel().addRow(row);
        infoStruct.setValidationDone(true);
        return infoStruct;
    }

    private int findCellPosition(int cellPosition, TableRowInfoStructure prevInfoStruct, TableRowInfoStructure infoStruct) {
        TableCell prevCell;
        while (cellPosition < prevInfoStruct.getCellCount() && (prevCell = prevInfoStruct.getCellAt(cellPosition)).getRowSpan() > 1) {
            DataCell dataCell;
            if (prevCell instanceof DataCell) {
                dataCell = (DataCell)prevCell;
            } else if (prevCell instanceof PlaceHolderCell) {
                PlaceHolderCell placeHolderCell = (PlaceHolderCell)prevCell;
                dataCell = placeHolderCell.getSourceCell();
            } else {
                throw new IllegalStateException("Unexpected cell type.");
            }
            int colSpan = prevCell.getColSpan();
            int rowSpan = prevCell.getRowSpan() - 1;
            for (int i = 0; i < colSpan; ++i) {
                PlaceHolderCell placeHolderCell = new PlaceHolderCell(dataCell, rowSpan, colSpan - i);
                infoStruct.addCell(placeHolderCell);
            }
            cellPosition += prevCell.getColSpan();
        }
        return cellPosition;
    }

    private int validateSafeCellPos(TableCellRenderBox cellBox, TableRowInfoStructure infoStruct, int cellPosition) {
        int colSpan = cellBox.getColSpan();
        int rowSpan = cellBox.getRowSpan();
        DataCell dataCell = new DataCell(rowSpan, colSpan, cellBox.getInstanceId());
        infoStruct.addCell(dataCell);
        ++cellPosition;
        for (int i = 1; i < colSpan; ++i) {
            PlaceHolderCell placeHolderCell = new PlaceHolderCell(dataCell, rowSpan, colSpan - i);
            infoStruct.addCell(placeHolderCell);
            ++cellPosition;
        }
        return cellPosition;
    }

    private void validatePredefinedColumns() {
        TableRenderBox table = this.currentTable.getTable();
        if (table.isPredefinedColumnsValidated()) {
            return;
        }
        TableColumnModel columnModel = table.getColumnModel();
        int colCount = 0;
        for (RenderNode node = table.getFirstChild(); node != null; node = node.getNext()) {
            if (node instanceof TableColumnNode) {
                TableColumnNode columnNode = (TableColumnNode)node;
                if (colCount < columnModel.getColumnCount()) continue;
                BoxDefinition boxDefinition = columnNode.getBoxDefinition();
                Border border = boxDefinition.getBorder();
                RenderLength width = boxDefinition.getPreferredWidth();
                TableColumn column = new TableColumn(border, width, false);
                TableColumnGroup group = new TableColumnGroup();
                group.addColumn(column);
                columnModel.addColumnGroup(group);
                ++colCount;
                continue;
            }
            if (node instanceof TableColumnGroupNode) {
                boolean newGroupGenerated;
                TableColumnGroup group;
                TableColumnGroupNode groupNode = (TableColumnGroupNode)node;
                if (colCount >= columnModel.getColumnCount()) {
                    group = new TableColumnGroup(groupNode.getBorder());
                    newGroupGenerated = true;
                } else {
                    group = columnModel.getGroupForIndex(colCount);
                    newGroupGenerated = false;
                }
                for (RenderNode groupColNode = groupNode.getFirstChild(); groupColNode != null; groupColNode = groupColNode.getNext()) {
                    if (!(groupColNode instanceof TableColumnNode)) continue;
                    TableColumnNode columnNode = (TableColumnNode)groupColNode;
                    if (colCount >= columnModel.getColumnCount()) {
                        BoxDefinition boxDefinition = columnNode.getBoxDefinition();
                        Border border = boxDefinition.getBorder();
                        RenderLength width = boxDefinition.getPreferredWidth();
                        TableColumn column = new TableColumn(border, width, false);
                        group.addColumn(column);
                        continue;
                    }
                    ++colCount;
                }
                if (!newGroupGenerated) continue;
                columnModel.addColumnGroup(group);
                colCount += group.getColumnCount();
                continue;
            }
            if (!(node instanceof TableSectionRenderBox)) continue;
            table.setPredefinedColumnsValidated(true);
        }
    }

    public static class TableInfoStructure {
        private TableRenderBox table;
        private TableColumnModel columnModel;
        private int columns;

        public TableInfoStructure(TableRenderBox table) {
            this.table = table;
            this.columnModel = table.getColumnModel();
            this.columns = this.columnModel.getColumnCount();
        }

        public TableRenderBox getTable() {
            return this.table;
        }

        public TableColumnModel getColumnModel() {
            return this.columnModel;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }
    }
}

