/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.fonts.encoding.CodePointBuffer;
import org.jfree.fonts.encoding.manual.Utf16LE;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.computed.ComputedToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.VariableToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCounterToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedStringToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedToken;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableTextBox;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.page.RenderPageContext;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.jfree.layouting.renderer.text.RenderableTextFactory;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class UpdateTokensStep
extends IterateStructuralProcessStep {
    private LayoutProcess layoutProcess;
    private RenderPageContext pageContext;
    private DocumentContext documentContext;
    private CodePointBuffer buffer;

    public void compute(LogicalPageBox pageBox, LayoutProcess layoutProcess, RenderPageContext pageContext) {
        this.layoutProcess = layoutProcess;
        this.pageContext = pageContext;
        this.documentContext = this.layoutProcess.getDocumentContext();
        try {
            this.startProcessing(pageBox);
        }
        catch (IllegalStateException ise) {
            Log.error((Object)"Unable to update tokens..");
        }
        this.documentContext = null;
        this.pageContext = null;
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        if (box instanceof RenderableTextBox) {
            RenderableTextBox textBox = (RenderableTextBox)box;
            ResolvedToken resolvedToken = textBox.getResolvedToken();
            String resolvedText = this.resolveToken(resolvedToken);
            if (ObjectUtilities.equal((Object)textBox.getResolvedText(), (Object)resolvedText)) {
                return false;
            }
            textBox.clear();
            State textFactory = textBox.getTextFactory();
            try {
                RenderableTextFactory rtf = (RenderableTextFactory)textFactory.restore(this.layoutProcess);
                RenderNode[] text = this.createText(resolvedText, textBox.getLayoutContext(), rtf);
                for (int i = 0; i < text.length; ++i) {
                    textBox.addGeneratedChild(text[i]);
                }
                RenderNode[] renderNodes = rtf.finishText();
                for (int i = 0; i < renderNodes.length; ++i) {
                    textBox.addGeneratedChild(renderNodes[i]);
                }
            }
            catch (StateException e) {
                Log.error((Object)"Failed to resolve token ");
                return false;
            }
            return false;
        }
        return true;
    }

    private RenderNode[] createText(String str, LayoutContext context, RenderableTextFactory textFactory) {
        if (this.buffer != null) {
            this.buffer.setCursor(0);
        }
        this.buffer = Utf16LE.getInstance().decodeString(str, this.buffer);
        int[] data = this.buffer.getBuffer();
        return textFactory.createText(data, 0, this.buffer.getLength(), context);
    }

    protected String resolveToken(ResolvedToken resolvedToken) {
        if (resolvedToken instanceof ResolvedStringToken) {
            ResolvedStringToken stringToken = (ResolvedStringToken)resolvedToken;
            ComputedToken parent = stringToken.getParent();
            if (parent instanceof VariableToken) {
                VariableToken vt = (VariableToken)parent;
                String variable = vt.getVariable();
                CSSValue stringPolicy = this.documentContext.getStringPolicy(variable);
                return this.pageContext.getString(variable, stringPolicy);
            }
        } else if (resolvedToken instanceof ResolvedCounterToken) {
            ResolvedCounterToken ct = (ResolvedCounterToken)resolvedToken;
            CounterToken parent = ct.getParent();
            String name = parent.getName();
            CounterStyle style = parent.getStyle();
            CSSValue counterPolicy = this.documentContext.getCounterPolicy(name);
            Integer counterValue = this.pageContext.getCounter(name, counterPolicy);
            return style.getCounterValue(counterValue);
        }
        return resolvedToken.getText();
    }
}

