/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;
import org.jfree.layouting.renderer.text.TextUtility;

public class BoxAlignContext
extends AlignContext {
    private long insetsTop;
    private long insetsBottom;
    private long[] baselines;
    private AlignContext firstChild;
    private AlignContext lastChild;

    public BoxAlignContext(RenderBox box) {
        super(box);
        ExtendedBaselineInfo baselineInfo = box.getBaselineInfo();
        if (baselineInfo == null) {
            baselineInfo = box.getNominalBaselineInfo();
        }
        CSSValue dominantBaselineValue = box.getDominantBaseline();
        this.setDominantBaseline(TextUtility.translateDominantBaseline(dominantBaselineValue, baselineInfo.getDominantBaseline()));
        ComputedLayoutProperties blp = box.getComputedLayoutProperties();
        this.insetsTop = blp.getBorderTop() + blp.getPaddingTop();
        this.insetsBottom = blp.getBorderBottom() + blp.getPaddingBottom();
        this.baselines = (long[])baselineInfo.getBaselines().clone();
        int i = 1;
        while (i < this.baselines.length) {
            int n = i++;
            this.baselines[n] = this.baselines[n] + this.insetsTop;
        }
        this.baselines[9] = this.baselines[8] + this.insetsBottom;
    }

    public void addChild(AlignContext context) {
        if (this.lastChild == null) {
            this.firstChild = context;
            this.lastChild = context;
            return;
        }
        this.lastChild.setNext(context);
        this.lastChild = context;
    }

    public AlignContext getFirstChild() {
        return this.firstChild;
    }

    public long getInsetsTop() {
        return this.insetsTop;
    }

    public long getInsetsBottom() {
        return this.insetsBottom;
    }

    public long getBaselineDistance(int baseline) {
        return this.baselines[baseline] - this.baselines[this.getDominantBaseline()];
    }

    public void shift(long delta) {
        int i = 0;
        while (i < this.baselines.length) {
            int n = i++;
            this.baselines[n] = this.baselines[n] + delta;
        }
        for (AlignContext child = this.getFirstChild(); child != null; child = child.getNext()) {
            child.shift(delta);
        }
    }

    public long getAfterEdge() {
        return this.baselines[9];
    }

    public long getBeforeEdge() {
        return this.baselines[0];
    }

    public void setBeforeEdge(long offset) {
        this.baselines[0] = offset;
    }

    public void setAfterEdge(long offset) {
        this.baselines[9] = offset;
    }
}

