/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;

public class InlineBlockAlignContext
extends AlignContext {
    private long[] baselines;
    private long baselineShift;

    public InlineBlockAlignContext(RenderBox box) {
        super(box);
        ExtendedBaselineInfo baselineInfo = box.getBaselineInfo();
        this.baselines = baselineInfo.getBaselines();
        this.setDominantBaseline(baselineInfo.getDominantBaseline());
    }

    public long getBaselineDistance(int baseline) {
        return this.baselines[baseline] - this.baselines[this.getDominantBaseline()] + this.baselineShift;
    }

    public void shift(long delta) {
        this.baselineShift += delta;
    }

    public long getAfterEdge() {
        return this.baselines[9] + this.baselineShift;
    }

    public long getBeforeEdge() {
        return this.baselines[0] + this.baselineShift;
    }
}

