/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;

public class TextElementAlignContext
extends AlignContext {
    private long[] baselines;
    private long baselineShift;

    public TextElementAlignContext(RenderableText text) {
        super(text);
        ExtendedBaselineInfo baselineInfo = text.getBaselineInfo();
        this.baselines = baselineInfo.getBaselines();
        this.setDominantBaseline(baselineInfo.getDominantBaseline());
    }

    public long getBaselineDistance(int baseline) {
        return this.baselines[baseline] - this.baselines[this.getDominantBaseline()] + this.baselineShift;
    }

    public void shift(long delta) {
        this.baselineShift += delta;
    }

    public long getAfterEdge() {
        return this.baselines[9] + this.baselineShift;
    }

    public long getBeforeEdge() {
        return this.baselines[0] + this.baselineShift;
    }
}

