/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.input.style.keys.line.BaselineShift;
import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.process.BoxShifter;
import org.jfree.layouting.renderer.process.InfiniteMajorAxisLayoutStep;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.renderer.process.valign.BoxAlignContext;
import org.jfree.layouting.renderer.process.valign.InlineBlockAlignContext;
import org.jfree.layouting.renderer.text.TextUtility;

public class VerticalAlignmentProcessor {
    private long lineHeight;
    private long minTopPos;
    private long maxBottomPos;
    private BoxAlignContext rootContext;
    private long sourcePosition;

    public void align(BoxAlignContext alignStructure, long y1, long lineHeight) {
        this.minTopPos = Long.MAX_VALUE;
        this.maxBottomPos = Long.MIN_VALUE;
        this.lineHeight = lineHeight;
        this.rootContext = alignStructure;
        this.sourcePosition = y1;
        this.performAlignment(alignStructure);
        this.performExtendedAlignment(alignStructure, alignStructure);
        this.normalizeAlignment(alignStructure);
        alignStructure.setAfterEdge(this.maxBottomPos);
        alignStructure.shift(-this.minTopPos + y1);
        this.apply(alignStructure);
        this.rootContext = null;
    }

    private void performAlignment(BoxAlignContext box) {
        for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
            if (child instanceof InlineBlockAlignContext) {
                InlineBlockAlignContext context = (InlineBlockAlignContext)child;
                InfiniteMajorAxisLayoutStep majorAxisLayoutStep = new InfiniteMajorAxisLayoutStep();
                majorAxisLayoutStep.continueComputation((RenderBox)context.getNode());
            }
            BoxAlignContext parent = box;
            CSSValue verticalAlignment = child.getNode().getVerticalAlignment();
            if (VerticalAlign.TOP.equals(verticalAlignment) || VerticalAlign.BOTTOM.equals(verticalAlignment)) {
                parent = this.rootContext;
            }
            long shiftDistance = this.computeShift(child, parent);
            int alignmentBaseline = TextUtility.translateAlignmentBaseline(child.getNode().getAlignmentBaseline(), child.getDominantBaseline());
            long childAlignmentPoint = this.computeAlignmentAdjust(child, alignmentBaseline);
            long childAscent = child.getBaselineDistance(0);
            long childPosition = -childAscent + childAlignmentPoint + child.getBeforeEdge();
            long parentAlignmentPoint = parent.getBaselineDistance(alignmentBaseline);
            long parentAscent = parent.getBaselineDistance(0);
            long parentPosition = -parentAscent + parentAlignmentPoint + parent.getBeforeEdge();
            long alignment = parentPosition - childPosition;
            long offset = shiftDistance + alignment;
            child.shift(offset);
            if (this.rootContext.getBeforeEdge() > child.getBeforeEdge()) {
                this.rootContext.setBeforeEdge(child.getBeforeEdge());
            }
            if (this.rootContext.getAfterEdge() < child.getAfterEdge()) {
                this.rootContext.setAfterEdge(child.getAfterEdge());
            }
            if (!(child instanceof BoxAlignContext)) continue;
            this.performAlignment((BoxAlignContext)child);
        }
    }

    private void normalizeAlignment(BoxAlignContext box) {
        this.minTopPos = Math.min(this.minTopPos, box.getBeforeEdge());
        this.maxBottomPos = Math.max(this.maxBottomPos, box.getAfterEdge());
        for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
            if (!(child instanceof BoxAlignContext)) continue;
            this.normalizeAlignment((BoxAlignContext)child);
        }
    }

    private long computeShift(AlignContext child, BoxAlignContext box) {
        RenderNode node = child.getNode();
        CSSValue baselineShift = node.getBaselineShift();
        if (baselineShift == null || BaselineShift.BASELINE.equals(baselineShift)) {
            return 0L;
        }
        if (BaselineShift.SUB.equals(baselineShift)) {
            return child.getBaselineDistance(6) - child.getBaselineDistance(5);
        }
        if (BaselineShift.SUPER.equals(baselineShift)) {
            return box.getBaselineDistance(5) - box.getBaselineDistance(6);
        }
        RenderLength baselineShiftResolved = node.getBaselineShiftResolved();
        if (baselineShiftResolved != null) {
            return baselineShiftResolved.resolve(this.lineHeight);
        }
        return 0L;
    }

    private long computeAlignmentAdjust(AlignContext context, int defaultBaseLine) {
        RenderNode node = context.getNode();
        CSSValue alignmentAdjust = node.getAlignmentAdjust();
        if (CSSAutoValue.getInstance().equals(alignmentAdjust)) {
            return context.getBaselineDistance(defaultBaseLine);
        }
        if (alignmentAdjust instanceof CSSConstant) {
            int baseline = TextUtility.translateAlignmentBaseline(alignmentAdjust, defaultBaseLine);
            return context.getBaselineDistance(baseline);
        }
        RenderLength alLength = node.getAlignmentAdjustResolved();
        if (alLength != null) {
            return alLength.resolve(this.lineHeight);
        }
        return context.getBaselineDistance(defaultBaseLine);
    }

    private void apply(BoxAlignContext box) {
        RenderNode node = box.getNode();
        node.setY(box.getBeforeEdge());
        node.setHeight(box.getAfterEdge() - box.getBeforeEdge());
        for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
            if (child instanceof BoxAlignContext) {
                this.apply((BoxAlignContext)child);
                continue;
            }
            if (child instanceof InlineBlockAlignContext) {
                BoxShifter boxShifter = new BoxShifter();
                long shift = child.getBeforeEdge() - this.sourcePosition;
                boxShifter.shiftBox((RenderBox)child.getNode(), shift);
                continue;
            }
            RenderNode childNode = child.getNode();
            childNode.setY(child.getBeforeEdge());
            childNode.setHeight(child.getAfterEdge() - child.getBeforeEdge());
        }
    }

    protected void print(BoxAlignContext alignContext, int level) {
        for (AlignContext child = alignContext.getFirstChild(); child != null; child = child.getNext()) {
            if (!(child instanceof BoxAlignContext)) continue;
            this.print((BoxAlignContext)child, level + 1);
        }
    }

    private void performExtendedAlignment(BoxAlignContext box, BoxAlignContext lineBox) {
        for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
            CSSValue verticalAlignment = child.getNode().getVerticalAlignment();
            if (VerticalAlign.TOP.equals(verticalAlignment)) {
                long childTopEdge = child.getBeforeEdge();
                long parentTopEdge = lineBox.getBeforeEdge();
                child.shift(parentTopEdge - childTopEdge);
            } else if (VerticalAlign.BOTTOM.equals(verticalAlignment)) {
                long childBottomEdge = child.getAfterEdge();
                long parentBottomEdge = lineBox.getAfterEdge();
                child.shift(parentBottomEdge - childBottomEdge);
            }
            if (!(child instanceof BoxAlignContext)) continue;
            this.performExtendedAlignment((BoxAlignContext)child, lineBox);
        }
    }
}

