/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.layouting.util.ChainingCallException;

public abstract class ChainingComponent {
    public static final int STATE_FRESH = 0;
    public static final int STATE_ERROR = 1;
    public static final int STATE_DONE = 2;
    private ArrayList calls = new ArrayList();

    public void addCall(RecordedCall c) {
        this.calls.add(c);
    }

    public void clear() {
        this.calls.clear();
    }

    protected RecordedCall[] retrieveRecordedCalls() {
        RecordedCall[] recordedCalls = this.calls.toArray(new RecordedCall[this.calls.size()]);
        this.calls.clear();
        return recordedCalls;
    }

    public void setRecordedCalls(RecordedCall[] recordedCalls) {
        this.calls.addAll(Arrays.asList(recordedCalls));
    }

    public synchronized void replay(Object target) throws ChainingCallException {
        RecordedCall[] recordedCalls = this.retrieveRecordedCalls();
        for (int i = 0; i < recordedCalls.length; ++i) {
            RecordedCall call = recordedCalls[i];
            if (call.getState() != 0) continue;
            try {
                this.invoke(target, call.getMethod(), call.getParameters());
                call.setState(2);
                continue;
            }
            catch (Exception e) {
                call.setState(1);
                throw new ChainingCallException("Chained Call failed:", e);
            }
        }
    }

    protected abstract void invoke(Object var1, int var2, Object var3) throws Exception;

    public static class RecordedCall {
        private int methodId;
        private Object parameters;
        private int state;

        public RecordedCall(int method, Object parameters) {
            this.methodId = method;
            this.parameters = parameters;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public int getMethod() {
            return this.methodId;
        }

        public Object getParameters() {
            return this.parameters;
        }
    }
}

