/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jfree.layouting.input.style.keys.color.CSSSystemColors;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSValue;

public class ColorUtil {
    private static final float ONE_THIRD = 0.33333334f;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$keys$color$HtmlColors;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$keys$color$SVGColors;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$keys$color$CSSSystemColors;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$values$CSSColorValue;

    private ColorUtil() {
    }

    public static float[] hslToRGB(int h, float s, float l) {
        float lightness;
        int hue = ColorUtil.normalizeHue(h);
        float saturation = s;
        if (saturation > 100.0f) {
            saturation = 100.0f;
        }
        if (saturation < 0.0f) {
            saturation = 0.0f;
        }
        if ((lightness = l) > 100.0f) {
            lightness = 100.0f;
        }
        if (lightness < 0.0f) {
            lightness = 0.0f;
        }
        float m2 = (double)lightness <= 0.5 ? lightness * (saturation + 1.0f) : lightness + saturation - lightness * saturation;
        float m1 = lightness * 2.0f - m2;
        float r = ColorUtil.hueToRGB(m1, m2, (float)hue + 0.33333334f);
        float g = ColorUtil.hueToRGB(m1, m2, hue);
        float b = ColorUtil.hueToRGB(m1, m2, (float)hue - 0.33333334f);
        return new float[]{r, g, b};
    }

    private static float hueToRGB(float m1, float m2, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (h * 6.0f < 1.0f) {
            return m1 + (m2 - m1) * h * 6.0f;
        }
        if (h * 2.0f < 1.0f) {
            return m2;
        }
        if (h * 3.0f < 2.0f) {
            return m1 + (m2 - m1) * (0.6666667f - h) * 6.0f;
        }
        return m1;
    }

    private static int normalizeHue(int integerValue) {
        return (integerValue % 360 + 360) % 360;
    }

    public static CSSValue parseColor(String colorSpec) {
        CSSValue color = ColorUtil.parseIdentColor(colorSpec);
        if (color != null) {
            return color;
        }
        try {
            if (colorSpec.length() == 4) {
                colorSpec = "#" + colorSpec.charAt(1) + colorSpec.charAt(1) + colorSpec.charAt(2) + colorSpec.charAt(2) + colorSpec.charAt(3) + colorSpec.charAt(3);
            }
            Integer decoded = Integer.decode(colorSpec);
            return new CSSColorValue(decoded, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CSSValue parseIdentColor(String name) {
        if (CSSSystemColors.CURRENT_COLOR.getCSSText().equalsIgnoreCase(name)) {
            return CSSSystemColors.CURRENT_COLOR;
        }
        CSSColorValue htmlColors = ColorUtil.parseColorFromClass(name, class$org$jfree$layouting$input$style$keys$color$HtmlColors == null ? (class$org$jfree$layouting$input$style$keys$color$HtmlColors = ColorUtil.class$("org.jfree.layouting.input.style.keys.color.HtmlColors")) : class$org$jfree$layouting$input$style$keys$color$HtmlColors);
        if (htmlColors != null) {
            return htmlColors;
        }
        CSSColorValue svgColors = ColorUtil.parseColorFromClass(name, class$org$jfree$layouting$input$style$keys$color$SVGColors == null ? (class$org$jfree$layouting$input$style$keys$color$SVGColors = ColorUtil.class$("org.jfree.layouting.input.style.keys.color.SVGColors")) : class$org$jfree$layouting$input$style$keys$color$SVGColors);
        if (svgColors != null) {
            return svgColors;
        }
        CSSColorValue systemColors = ColorUtil.parseColorFromClass(name, class$org$jfree$layouting$input$style$keys$color$CSSSystemColors == null ? (class$org$jfree$layouting$input$style$keys$color$CSSSystemColors = ColorUtil.class$("org.jfree.layouting.input.style.keys.color.CSSSystemColors")) : class$org$jfree$layouting$input$style$keys$color$CSSSystemColors);
        if (systemColors != null) {
            return systemColors;
        }
        return null;
    }

    private static CSSColorValue parseColorFromClass(String name, Class c) {
        Field[] f = c.getFields();
        for (int i = 0; i < f.length; ++i) {
            try {
                Field field = f[i];
                if (!field.getName().equalsIgnoreCase(name) || !(class$org$jfree$layouting$input$style$values$CSSColorValue == null ? ColorUtil.class$("org.jfree.layouting.input.style.values.CSSColorValue") : class$org$jfree$layouting$input$style$values$CSSColorValue).isAssignableFrom(field.getType()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                return (CSSColorValue)field.get(null);
            }
            catch (Exception ce) {
                // empty catch block
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

