/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.io.Serializable;

public class LongList
implements Serializable,
Cloneable {
    private static final long[] EMPTY_ARRAY = new long[0];
    private long[] data;
    private int size;
    private int increment;

    public LongList(int capacity) {
        this.data = new long[capacity];
        this.increment = capacity;
    }

    private void ensureCapacity(int c) {
        if (this.data.length <= c) {
            long[] newData = new long[Math.max(this.data.length + this.increment, c + 1)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void add(long value) {
        this.ensureCapacity(this.size);
        this.data[this.size] = value;
        ++this.size;
    }

    public void set(int index, long value) {
        this.ensureCapacity(index);
        this.data[index] = value;
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    public long get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Illegal Index: " + index + " Max:" + this.size);
        }
        return this.data[index];
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public long[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        return (long[])this.data.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        LongList intList = (LongList)super.clone();
        intList.data = (long[])this.data.clone();
        return this.data;
    }
}

