/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util.geom;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.jfree.layouting.util.geom.StrictBounds;
import org.jfree.layouting.util.geom.StrictDimension;
import org.jfree.layouting.util.geom.StrictPoint;
import org.jfree.ui.FloatDimension;

public class StrictGeomUtility {
    private static final double CORRECTION_FACTOR = 1000.0;

    private StrictGeomUtility() {
    }

    public static StrictDimension createDimension(double w, double h) {
        return new StrictDimension((long)(w * 1000.0), (long)(h * 1000.0));
    }

    public static StrictPoint createPoint(double x, double y) {
        return new StrictPoint((long)(x * 1000.0), (long)(y * 1000.0));
    }

    public static StrictBounds createBounds(double x, double y, double width, double height) {
        return new StrictBounds((long)(x * 1000.0), (long)(y * 1000.0), (long)(width * 1000.0), (long)(height * 1000.0));
    }

    public static Dimension2D createAWTDimension(long width, long height) {
        return new FloatDimension((float)((double)width / 1000.0), (float)((double)height / 1000.0));
    }

    public static Rectangle2D createAWTRectangle(long x, long y, long width, long height) {
        return new Rectangle2D.Double((double)x / 1000.0, (double)y / 1000.0, (double)width / 1000.0, (double)height / 1000.0);
    }

    public static long toInternalValue(double value) {
        return (long)(value * 1000.0);
    }

    public static double toExternalValue(long value) {
        return (double)value / 1000.0;
    }

    public static long multiply(long x, long y) {
        return (long)((double)(x * y) / 1000.0);
    }
}

