/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts;

import java.io.IOException;
import org.jfree.fonts.registry.FontSource;
import org.jfree.fonts.truetype.TrueTypeFontRegistry;

public class FontTypeTest {
    private FontTypeTest() {
    }

    private static void printRecord(FontSource record) {
        if (record == null) {
            System.out.println("  -");
        } else if (record.isItalic() || record.isOblique()) {
            System.out.println("  " + record.getName() + " it:" + record.isItalic() + " ob:" + record.isOblique());
        }
    }

    public static void main(String[] args) throws IOException {
        Object family;
        TrueTypeFontRegistry registry = new TrueTypeFontRegistry();
        registry.initialize();
        String[] fontFamilies = registry.getRegisteredFamilies();
        for (int i = 0; i < fontFamilies.length; ++i) {
            String fontFamily = fontFamilies[i];
            System.out.println("FontFamily: " + fontFamily);
            family = registry.getFontFamily(fontFamily);
            FontTypeTest.printRecord((FontSource)family.getFontRecord(false, false));
            FontTypeTest.printRecord((FontSource)family.getFontRecord(true, false));
            FontTypeTest.printRecord((FontSource)family.getFontRecord(false, true));
            FontTypeTest.printRecord((FontSource)family.getFontRecord(true, true));
        }
        String[] allFontFamilies = registry.getAllRegisteredFamilies();
        for (int i = 0; i < allFontFamilies.length; ++i) {
            family = allFontFamilies[i];
            System.out.println("I18n: FontFamily: " + (String)family);
        }
        System.out.println(registry.getFontFamily("Skolle"));
        System.out.println(registry.getFontFamily("Tahoma2"));
    }
}

