/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.jfree.fonts.encoding.CodePointUtilities;
import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontMetrics;

public class AWTFontMetrics
implements FontMetrics {
    private static final Graphics2D[] graphics = new Graphics2D[4];
    private Font font;
    private java.awt.FontMetrics fontMetrics;
    private double lineHeight;
    private double maxCharAdvance;
    private char[] cpBuffer;
    private FontRenderContext frc;
    private double xheight;
    private double[] cachedWidths;
    private BaselineInfo[] cachedBaselines;

    public AWTFontMetrics(Font font, FontContext context) {
        this.font = font;
        this.frc = new FontRenderContext(null, context.isAntiAliased(), context.isFractionalMetrics());
        Graphics2D graphics = this.createGraphics(context);
        this.fontMetrics = graphics.getFontMetrics(font);
        Rectangle2D rect = this.font.getMaxCharBounds(this.frc);
        this.lineHeight = rect.getHeight();
        this.maxCharAdvance = rect.getWidth();
        GlyphVector gv = font.createGlyphVector(this.frc, "x");
        Rectangle2D bounds = gv.getVisualBounds();
        this.xheight = bounds.getHeight();
        this.cpBuffer = new char[4];
        this.cachedBaselines = new BaselineInfo[224];
        this.cachedWidths = new double[224];
        Arrays.fill(this.cachedWidths, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Graphics2D createGraphics(FontContext context) {
        int idx = 0;
        if (context.isAntiAliased()) {
            ++idx;
        }
        if (context.isFractionalMetrics()) {
            idx += 2;
        }
        Graphics2D[] graphics2DArray = graphics;
        synchronized (graphics) {
            Graphics2D retval = graphics[idx];
            if (retval == null) {
                BufferedImage image = new BufferedImage(1, 1, 2);
                Graphics2D g2 = image.createGraphics();
                if (context.isAntiAliased()) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                if (context.isFractionalMetrics()) {
                    g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                }
                AWTFontMetrics.graphics[idx] = g2;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return g2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return retval;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public double getAscent() {
        return this.fontMetrics.getAscent();
    }

    public double getDescent() {
        return this.fontMetrics.getDescent();
    }

    public double getLeading() {
        return this.fontMetrics.getLeading();
    }

    public double getXHeight() {
        return this.xheight;
    }

    public double getOverlinePosition() {
        return 0.0;
    }

    public double getUnderlinePosition() {
        return 0.0;
    }

    public double getStrikeThroughPosition() {
        return 0.0;
    }

    public double getMaxAscent() {
        return this.fontMetrics.getMaxAscent();
    }

    public double getMaxDescent() {
        return this.fontMetrics.getMaxDescent();
    }

    public double getMaxLeading() {
        return this.lineHeight - this.getMaxAscent() - this.getMaxDescent();
    }

    public double getMaxHeight() {
        return this.lineHeight;
    }

    public double getMaxCharAdvance() {
        return this.maxCharAdvance;
    }

    public synchronized double getCharWidth(int character) {
        if (character >= 32 && character < 256) {
            int index = character - 32;
            double cachedWidth = this.cachedWidths[index];
            if (cachedWidth >= 0.0) {
                return cachedWidth;
            }
            int retval = CodePointUtilities.toChars(character, this.cpBuffer, 0);
            if (retval > 0) {
                double width;
                Rectangle2D lm = this.font.getStringBounds(this.cpBuffer, 0, retval, this.frc);
                this.cachedWidths[index] = width = lm.getWidth();
                return width;
            }
            this.cachedWidths[index] = 0.0;
            return 0.0;
        }
        int retval = CodePointUtilities.toChars(character, this.cpBuffer, 0);
        if (retval > 0) {
            Rectangle2D lm = this.font.getStringBounds(this.cpBuffer, 0, retval, this.frc);
            return lm.getWidth();
        }
        return 0.0;
    }

    public synchronized double getKerning(int previous, int character) {
        int retvalC1 = CodePointUtilities.toChars(previous, this.cpBuffer, 0);
        if (retvalC1 <= 0) {
            return 0.0;
        }
        int retvalC2 = CodePointUtilities.toChars(character, this.cpBuffer, retvalC1);
        if (retvalC2 > 0) {
            int limit = retvalC1 + retvalC2;
            GlyphVector gv = this.font.createGlyphVector(this.frc, new String(this.cpBuffer, 0, limit));
            double totalSize = gv.getGlyphPosition(limit).getX();
            double renderedWidth = gv.getOutline().getBounds2D().getWidth();
            return totalSize - renderedWidth;
        }
        return 0.0;
    }

    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        BaselineInfo fromCache;
        boolean cacheable;
        boolean bl = cacheable = c >= 32 && c < 256;
        if (cacheable && (fromCache = this.cachedBaselines[c - 32]) != null) {
            if (info == null) {
                info = new BaselineInfo();
            }
            info.update(fromCache);
            return info;
        }
        this.cpBuffer[0] = (char)(c & 0xFFFF);
        LineMetrics lm = this.font.getLineMetrics(this.cpBuffer, 0, 1, this.frc);
        float[] bls = lm.getBaselineOffsets();
        int idx = lm.getBaselineIndex();
        if (info == null) {
            info = new BaselineInfo();
        }
        double maxAscent = this.getMaxAscent();
        double delta = maxAscent - (double)lm.getAscent();
        info.setBaseline(1, delta + maxAscent - this.getXHeight());
        info.setBaseline(5, this.getMaxHeight());
        info.setBaseline(3, maxAscent / 2.0);
        double base = delta + (double)lm.getAscent();
        switch (idx) {
            case 1: {
                info.setBaseline(2, base);
                info.setBaseline(4, base + (double)bls[0]);
                info.setBaseline(0, base + (double)bls[2]);
                info.setDominantBaseline(2);
                break;
            }
            case 2: {
                info.setBaseline(2, base + (double)bls[1]);
                info.setBaseline(4, base + (double)bls[0]);
                info.setBaseline(0, base);
                info.setDominantBaseline(0);
                break;
            }
            default: {
                info.setBaseline(4, base);
                info.setBaseline(2, base + (double)bls[1]);
                info.setBaseline(0, base + (double)bls[2]);
                info.setDominantBaseline(4);
            }
        }
        if (cacheable) {
            BaselineInfo cached = new BaselineInfo();
            cached.update(info);
            this.cachedBaselines[c - 32] = cached;
        }
        return info;
    }
}

