/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.awt;

import java.awt.Font;
import org.jfree.fonts.awt.AWTFontMetrics;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.registry.FontType;

public class AWTFontMetricsFactory
implements FontMetricsFactory {
    public FontMetrics createMetrics(FontIdentifier identifier, FontContext context) {
        if (!FontType.AWT.equals(identifier.getFontType())) {
            throw new IllegalArgumentException("This identifier does not belong to the AWT-font system.");
        }
        FontRecord record = (FontRecord)((Object)identifier);
        int style = 0;
        if (record.isBold()) {
            style |= 1;
        }
        if (record.isItalic()) {
            style |= 2;
        }
        Font font = new Font(record.getFamily().getFamilyName(), style, (int)context.getFontSize());
        return new AWTFontMetrics(font, context);
    }
}

