/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.awt;

import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.registry.FontType;

public class AWTFontRecord
implements FontRecord,
FontIdentifier {
    private FontFamily fontFamily;
    private boolean bold;
    private boolean italics;

    public AWTFontRecord(FontFamily fontFamily, boolean bold, boolean italics) {
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.fontFamily = fontFamily;
        this.bold = bold;
        this.italics = italics;
    }

    public FontFamily getFamily() {
        return this.fontFamily;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italics;
    }

    public boolean isOblique() {
        return this.italics;
    }

    public FontIdentifier getIdentifier() {
        return this;
    }

    public boolean isScalable() {
        return true;
    }

    public FontType getFontType() {
        return FontType.AWT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWTFontRecord that = (AWTFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.italics != that.italics) {
            return false;
        }
        return this.fontFamily.equals(that.fontFamily);
    }

    public int hashCode() {
        int result = this.fontFamily.hashCode();
        result = 29 * result + (this.bold ? 1 : 0);
        result = 29 * result + (this.italics ? 1 : 0);
        return result;
    }
}

