/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding;

import java.io.Serializable;

public class ByteBuffer
implements Serializable {
    private byte[] data;
    private int offset;
    private int cursor;

    public ByteBuffer(int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new byte[length];
        this.offset = 0;
        this.cursor = 0;
    }

    public ByteBuffer(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.offset = 0;
        this.cursor = data.length;
    }

    public ByteBuffer(byte[] data, int offset, int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        if (length + offset > data.length) {
            throw new IndexOutOfBoundsException();
        }
        this.data = data;
        this.offset = offset;
        this.cursor = offset + length;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data, int length, int offset) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length < 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset < 0");
        }
        if (length + offset >= data.length) {
            throw new IllegalArgumentException("Length + Offset");
        }
        this.data = data;
        this.cursor = length + offset;
        this.offset = offset;
    }

    public int getLength() {
        return this.cursor - this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void ensureSize(int length) {
        if (this.data.length < this.offset + length) {
            byte[] newdata = new byte[this.offset + length];
            System.arraycopy(this.data, 0, newdata, 0, this.data.length);
            this.data = newdata;
        }
    }

    public void setCursor(int cursor) {
        if (cursor < this.offset) {
            throw new IndexOutOfBoundsException();
        }
        if (cursor > this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        this.cursor = cursor;
    }
}

