/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding;

import java.io.Serializable;

public class CodePointBuffer
implements Serializable {
    private int[] data;
    private int offset;
    private int cursor;

    public CodePointBuffer(int[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.offset = 0;
        this.cursor = 0;
    }

    public CodePointBuffer(int length) {
        this.data = new int[length];
        this.offset = 0;
        this.cursor = 0;
    }

    public int[] getBuffer() {
        int length = this.getLength();
        int[] retval = new int[length];
        System.arraycopy(this.data, this.offset, retval, 0, length);
        return retval;
    }

    public int[] getData() {
        return this.data;
    }

    public void setData(int[] data, int length, int offset) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length < 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset < 0");
        }
        if (length + offset > data.length) {
            throw new IllegalArgumentException("Length + Offset");
        }
        this.data = data;
        this.cursor = length + offset;
        this.offset = offset;
    }

    public int getLength() {
        return this.cursor - this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void ensureSize(int length) {
        if (this.data.length < this.offset + length) {
            int[] newdata = new int[this.offset + length];
            System.arraycopy(this.data, 0, newdata, 0, this.data.length);
            this.data = newdata;
        }
    }

    public void setCursor(int cursor) {
        if (cursor < this.offset) {
            throw new IndexOutOfBoundsException();
        }
        if (cursor > this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        this.cursor = cursor;
    }
}

