/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jfree.fonts.LibFontBoot;
import org.jfree.fonts.encoding.Encoding;
import org.jfree.fonts.encoding.EncodingCore;
import org.jfree.fonts.encoding.EncodingFactory;
import org.jfree.fonts.encoding.ExternalEncoding;
import org.jfree.fonts.encoding.manual.Ascii;
import org.jfree.fonts.encoding.manual.BuiltInJavaEncoding;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.factory.property.PropertiesResourceFactory;
import org.jfree.util.ExtendedConfiguration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public final class EncodingRegistry {
    private static final String TEST_STRING = " ";
    private HashMap encodingsMapping;
    private HashMap generatedMapping;
    private HashMap fallbackMapping;
    private HashMap aliases;
    private ResourceManager manager = new ResourceManager();
    private static EncodingRegistry instance;
    public static final String ENCODING_ALIAS_PREFIX = "org.jfree.fonts.encoding.alias.";
    static /* synthetic */ Class class$org$jfree$fonts$encoding$EncodingRegistry;
    static /* synthetic */ Class class$org$jfree$fonts$encoding$Encoding;
    static /* synthetic */ Class class$java$util$Properties;

    public static synchronized EncodingRegistry getInstance() {
        if (instance == null) {
            instance = new EncodingRegistry();
            instance.registerDefaults();
        }
        return instance;
    }

    private EncodingRegistry() {
        this.manager.registerFactoryCache();
        this.manager.registerDataCache();
        this.manager.registerDefaultLoaders();
        this.manager.registerFactory((ResourceFactory)new EncodingFactory());
        this.manager.registerFactory((ResourceFactory)new PropertiesResourceFactory());
        this.encodingsMapping = new HashMap();
        this.generatedMapping = new HashMap();
        this.fallbackMapping = new HashMap();
        this.aliases = new HashMap();
    }

    private void registerDefaults() {
        ExtendedConfiguration config = LibFontBoot.getInstance().getExtendedConfig();
        Iterator encodings = config.findPropertyKeys("org.jfree.fonts.encoding.manual.");
        while (encodings.hasNext()) {
            String key = (String)encodings.next();
            String encodingClass = config.getConfigProperty(key);
            Object maybeEncoding = ObjectUtilities.loadAndInstantiate((String)encodingClass, (Class)(class$org$jfree$fonts$encoding$EncodingRegistry == null ? EncodingRegistry.class$("org.jfree.fonts.encoding.EncodingRegistry") : class$org$jfree$fonts$encoding$EncodingRegistry), (Class)(class$org$jfree$fonts$encoding$Encoding == null ? EncodingRegistry.class$("org.jfree.fonts.encoding.Encoding") : class$org$jfree$fonts$encoding$Encoding));
            if (maybeEncoding == null) continue;
            Encoding encoding = (Encoding)maybeEncoding;
            String name = encoding.getName();
            this.encodingsMapping.put(this.normalizeEncodingName(name), encodingClass);
        }
        Iterator generateDirs = config.findPropertyKeys("org.jfree.fonts.encoding.generated.");
        while (generateDirs.hasNext()) {
            String key = (String)generateDirs.next();
            String dataLocation = config.getConfigProperty(key);
            try {
                ResourceKey resKey = this.manager.createKey((Object)dataLocation);
                Resource res = this.manager.create(resKey, null, class$java$util$Properties == null ? EncodingRegistry.class$("java.util.Properties") : class$java$util$Properties);
                Properties props = (Properties)res.getResource();
                Iterator<Map.Entry<Object, Object>> vals = props.entrySet().iterator();
                while (vals.hasNext()) {
                    Map.Entry<Object, Object> entry = vals.next();
                    String encName = (String)entry.getKey();
                    String encPath = (String)entry.getValue();
                    ResourceKey encKey = this.manager.deriveKey(resKey, encPath);
                    this.generatedMapping.put(this.normalizeEncodingName(encName), encKey);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator aliasesIt = config.findPropertyKeys(ENCODING_ALIAS_PREFIX);
        while (aliasesIt.hasNext()) {
            String key = (String)aliasesIt.next();
            String alias = key.substring(ENCODING_ALIAS_PREFIX.length());
            String target = config.getConfigProperty(key);
            this.aliases.put(this.normalizeEncodingName(alias), this.normalizeEncodingName(target));
        }
    }

    public boolean isSupportedEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        String key = this.normalizeEncodingName(encoding);
        if (this.encodingsMapping.containsKey(key)) {
            return true;
        }
        if (this.generatedMapping.containsKey(key)) {
            return true;
        }
        return this.isEncodingSupportedJVM(encoding);
    }

    private String normalizeEncodingName(String name) {
        String lcName = name.toLowerCase();
        String retval = lcName.replace('_', '-');
        String alias = (String)this.aliases.get(retval);
        if (alias != null) {
            return alias;
        }
        return retval;
    }

    private boolean isEncodingSupportedJVM(String encoding) {
        try {
            TEST_STRING.getBytes(encoding);
            this.fallbackMapping.put(encoding, Boolean.TRUE);
            return true;
        }
        catch (Exception ue) {
            Log.info((Object)new Log.SimpleMessage("Encoding ", (Object)encoding, (Object)" is not supported."));
            return false;
        }
    }

    public static String getPlattformDefaultEncoding() {
        return LibFontBoot.getInstance().getGlobalConfig().getConfigProperty("file.encoding", "Cp1252");
    }

    public Encoding getEncoding(String name) {
        String key = this.normalizeEncodingName(name);
        String manual = (String)this.encodingsMapping.get(key);
        if (manual != null) {
            return (Encoding)ObjectUtilities.loadAndInstantiate((String)manual, (Class)(class$org$jfree$fonts$encoding$EncodingRegistry == null ? (class$org$jfree$fonts$encoding$EncodingRegistry = EncodingRegistry.class$("org.jfree.fonts.encoding.EncodingRegistry")) : class$org$jfree$fonts$encoding$EncodingRegistry), (Class)(class$org$jfree$fonts$encoding$Encoding == null ? (class$org$jfree$fonts$encoding$Encoding = EncodingRegistry.class$("org.jfree.fonts.encoding.Encoding")) : class$org$jfree$fonts$encoding$Encoding));
        }
        ResourceKey generated = (ResourceKey)this.generatedMapping.get(key);
        if (generated != null) {
            try {
                Resource res = this.manager.create(generated, null, class$org$jfree$fonts$encoding$Encoding == null ? (class$org$jfree$fonts$encoding$Encoding = EncodingRegistry.class$("org.jfree.fonts.encoding.Encoding")) : class$org$jfree$fonts$encoding$Encoding);
                Object o = res.getResource();
                if (o instanceof EncodingCore) {
                    return new ExternalEncoding(name, (EncodingCore)o, res);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.isEncodingSupportedJVM(name)) {
            return new BuiltInJavaEncoding(name, true);
        }
        if (this.isEncodingSupportedJVM(key)) {
            return new BuiltInJavaEncoding(key, true);
        }
        return new Ascii();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

