/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding.generator;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jfree.fonts.LibFontBoot;
import org.jfree.fonts.encoding.External8BitEncodingData;
import org.jfree.util.DefaultConfiguration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class EncodingGenerator {
    private File targetDirectory;
    private DefaultConfiguration propertySet;
    private File sourceDirectory;
    public static final Integer ZERO = new Integer(0);
    static /* synthetic */ Class class$org$jfree$fonts$encoding$generator$EncodingGenerator;

    public EncodingGenerator(File targetDirectory, File sourceDirectory) throws IOException {
        if (targetDirectory == null) {
            throw new NullPointerException();
        }
        if (!targetDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + targetDirectory);
        }
        if (!targetDirectory.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + targetDirectory);
        }
        if (sourceDirectory == null) {
            throw new NullPointerException();
        }
        if (!sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + sourceDirectory);
        }
        if (!sourceDirectory.canRead()) {
            throw new IllegalArgumentException("Not readable: " + sourceDirectory);
        }
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
        InputStream propIn = ObjectUtilities.getResourceRelativeAsStream((String)"encodings.properties", (Class)(class$org$jfree$fonts$encoding$generator$EncodingGenerator == null ? (class$org$jfree$fonts$encoding$generator$EncodingGenerator = EncodingGenerator.class$("org.jfree.fonts.encoding.generator.EncodingGenerator")) : class$org$jfree$fonts$encoding$generator$EncodingGenerator));
        this.propertySet = new DefaultConfiguration();
        this.propertySet.load(propIn);
    }

    public void generatedFormatA(Properties specifications, BufferedReader input, OutputStream output) throws IOException {
        if (input == null) {
            throw new NullPointerException();
        }
        if (output == null) {
            throw new NullPointerException();
        }
        if (specifications == null) {
            throw new NullPointerException();
        }
        Integer[] data = new Integer[256];
        data[0] = ZERO;
        String s = input.readLine();
        while (s != null) {
            String targetChar;
            if (s.startsWith("#")) {
                s = input.readLine();
                continue;
            }
            StringTokenizer strtok = new StringTokenizer(s);
            if (!strtok.hasMoreTokens()) {
                s = input.readLine();
                continue;
            }
            String sourceChar = strtok.nextToken().trim();
            if (sourceChar.length() == 0) {
                s = input.readLine();
                continue;
            }
            Integer sourceVal = Integer.decode(sourceChar);
            if (strtok.hasMoreTokens() && !(targetChar = strtok.nextToken()).startsWith("#")) {
                data[sourceVal.intValue()] = Integer.decode(targetChar);
            }
            s = input.readLine();
        }
        int[] indices = new int[256];
        int[] values = new int[256];
        int index = 0;
        int prevIdx = 0;
        for (int i = 1; i < data.length; ++i) {
            Integer integer = data[i];
            if (integer == null) continue;
            Integer prev = data[prevIdx];
            values[index] = integer - prev;
            indices[index] = i - prevIdx;
            prevIdx = i;
            ++index;
        }
        ObjectOutputStream oout = new ObjectOutputStream(output);
        oout.writeObject(new External8BitEncodingData(indices, values));
        oout.flush();
    }

    public void generateAll() throws IOException {
        Iterator keys = this.propertySet.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("encodings.")) {
                Log.info((Object)"Encoding prefix not found.");
                continue;
            }
            if (!key.endsWith(".Filename")) continue;
            try {
                this.generate(key.substring(0, key.length() - 8));
            }
            catch (Exception e) {
                Log.warn((Object)("Failed to generate Encoding " + key), (Exception)e);
            }
        }
    }

    public void generate(String prefix) throws IOException {
        String filename = this.propertySet.getConfigProperty(prefix + "Filename");
        String className = this.propertySet.getConfigProperty(prefix + "ClassName");
        String encoding = this.propertySet.getConfigProperty(prefix + "Encoding");
        if (filename == null) {
            Log.info((Object)("Not generating Encoding: " + prefix + ": Filename missing"));
            return;
        }
        if (className == null) {
            Log.info((Object)("Not generating Encoding: " + prefix + ": ClassName missing"));
            return;
        }
        if (encoding == null) {
            Log.info((Object)("Not generating Encoding: " + prefix + ": Encoding missing"));
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("name", className);
        properties.setProperty("source", filename);
        properties.setProperty("encoding", encoding);
        File sourceFile = new File(this.sourceDirectory, className + ".ser");
        File targetFile = new File(this.targetDirectory, filename);
        System.out.println("Generated Java File:  " + sourceFile);
        System.out.println("Source Specification: " + targetFile);
        BufferedOutputStream bw = new BufferedOutputStream(new FileOutputStream(sourceFile));
        BufferedReader input = new BufferedReader(new FileReader(targetFile));
        this.generatedFormatA(properties, input, bw);
        input.close();
        bw.close();
    }

    public void generatePropertyIndex() throws IOException {
        Properties props = new Properties();
        Iterator keys = this.propertySet.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("encodings.")) {
                Log.info((Object)"Encoding prefix not found.");
                continue;
            }
            if (!key.endsWith(".Filename")) continue;
            try {
                this.generateEncodingEntry(props, key.substring(0, key.length() - 8));
            }
            catch (Exception e) {
                Log.warn((Object)("Failed to generate Encoding " + key), (Exception)e);
            }
        }
        File sourceFile = new File(this.sourceDirectory, "encodings.properties");
        FileOutputStream fout = new FileOutputStream(sourceFile);
        props.store(fout, "Generated on " + new Date());
        fout.close();
    }

    private void generateEncodingEntry(Properties props, String prefix) {
        String className = this.propertySet.getConfigProperty(prefix + "ClassName");
        String encoding = this.propertySet.getConfigProperty(prefix + "Encoding");
        if (className == null) {
            Log.info((Object)("Not generating Encoding: " + prefix + ": ClassName missing"));
            return;
        }
        if (encoding == null) {
            Log.info((Object)("Not generating Encoding: " + prefix + ": Encoding missing"));
            return;
        }
        props.setProperty(encoding, className + ".ser");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            throw new IllegalArgumentException("Need two parameters: SourceDirectory and targetDirectory");
        }
        String sourceDirectory = args[0];
        String targetDirectory = args[1];
        LibFontBoot.getInstance().start();
        File encodingsDir = new File(sourceDirectory).getAbsoluteFile();
        File sourceDir = new File(targetDirectory).getAbsoluteFile();
        EncodingGenerator gen = new EncodingGenerator(encodingsDir, sourceDir);
        gen.generateAll();
        gen.generatePropertyIndex();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

