/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding.manual;

import java.util.Locale;
import org.jfree.fonts.encoding.ByteBuffer;
import org.jfree.fonts.encoding.CodePointBuffer;
import org.jfree.fonts.encoding.Encoding;
import org.jfree.fonts.encoding.EncodingErrorType;
import org.jfree.fonts.encoding.EncodingException;

public final class Ascii
implements Encoding {
    public String getName() {
        return "ASCII";
    }

    public String getName(Locale locale) {
        return this.getName();
    }

    public boolean isUnicodeCharacterSupported(int c) {
        return (c & 0xFFFFFF80) == 0;
    }

    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new ByteBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        byte[] targetArray = buffer.getData();
        int[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            int sourceItem = sourceArray[i];
            if (!this.isUnicodeCharacterSupported(sourceItem)) continue;
            targetArray[targetIdx] = (byte)(sourceItem & 0x7F);
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new CodePointBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        int[] targetArray = buffer.getData();
        byte[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            targetArray[targetIdx] = sourceArray[i] & 0x7F;
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new ByteBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        byte[] targetArray = buffer.getData();
        int[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            int sourceItem = sourceArray[i];
            if (this.isUnicodeCharacterSupported(sourceItem)) {
                targetArray[targetIdx] = (byte)(sourceItem & 0x7F);
                ++targetIdx;
                continue;
            }
            if (errorHandling == EncodingErrorType.REPLACE) {
                targetArray[targetIdx] = 63;
                ++targetIdx;
                continue;
            }
            if (errorHandling != EncodingErrorType.FAIL) continue;
            throw new EncodingException();
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new CodePointBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        int[] targetArray = buffer.getData();
        byte[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            targetArray[targetIdx] = sourceArray[i] & 0x7F;
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }
}

