/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.monospace;

import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontMetrics;

public class MonospaceFontMetrics
implements FontMetrics {
    private double charHeight;
    private double charWidth;

    public MonospaceFontMetrics(float cpi, float lpi) {
        this.charHeight = 72.0 / (double)lpi;
        this.charWidth = 72.0 / (double)cpi;
    }

    public double getAscent() {
        return 0.7 * this.charHeight;
    }

    public double getDescent() {
        return 0.3 * this.charHeight;
    }

    public double getLeading() {
        return 0.0;
    }

    public double getXHeight() {
        return 0.5 * this.charHeight;
    }

    public double getOverlinePosition() {
        return this.getAscent();
    }

    public double getUnderlinePosition() {
        return this.getAscent() + 0.5 * this.getDescent();
    }

    public double getStrikeThroughPosition() {
        return 0.5 * this.getXHeight();
    }

    public double getMaxAscent() {
        return this.getAscent();
    }

    public double getMaxDescent() {
        return this.getDescent();
    }

    public double getMaxLeading() {
        return this.getLeading();
    }

    public double getMaxHeight() {
        return this.charHeight;
    }

    public double getMaxCharAdvance() {
        return this.charWidth;
    }

    public double getCharWidth(int codePoint) {
        return this.charWidth;
    }

    public double getKerning(int previous, int codePoint) {
        return 0.0;
    }

    public BaselineInfo getBaselines(int codePoint, BaselineInfo info) {
        if (info == null) {
            info = new BaselineInfo();
        }
        info.setBaseline(0, 0.0);
        info.setBaseline(1, this.charHeight * 0.5);
        info.setBaseline(2, this.charHeight * 0.5);
        info.setBaseline(3, this.charHeight * 0.5);
        info.setBaseline(4, this.getMaxAscent());
        info.setBaseline(5, this.getMaxHeight());
        return info;
    }
}

