/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.monospace;

import java.util.HashMap;
import org.jfree.fonts.monospace.MonospaceFontFamily;
import org.jfree.fonts.monospace.MonospaceFontMetricsFactory;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.registry.FontRegistry;

public class MonospaceFontRegistry
implements FontRegistry {
    private HashMap fontFamilies;
    private float lpi;
    private float cpi;
    private MonospaceFontFamily fallback;

    public MonospaceFontRegistry(float lpi, float cpi) {
        this.lpi = lpi;
        this.cpi = cpi;
        this.fontFamilies = new HashMap();
        this.fallback = new MonospaceFontFamily("Monospace");
    }

    public void add(MonospaceFontFamily family) {
        this.fontFamilies.put(family.getFamilyName(), family);
    }

    public MonospaceFontFamily getFallback() {
        return this.fallback;
    }

    public void setFallback(MonospaceFontFamily fallback) {
        this.fallback = fallback;
    }

    public void initialize() {
    }

    public FontFamily getFontFamily(String name) {
        FontFamily fontFamily = (FontFamily)this.fontFamilies.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        return this.fallback;
    }

    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    public String[] getAllRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    public FontMetricsFactory createMetricsFactory() {
        return new MonospaceFontMetricsFactory(this.lpi, this.cpi);
    }
}

