/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.registry;

public final class BaselineInfo {
    public static final int HANGING = 0;
    public static final int MATHEMATICAL = 1;
    public static final int CENTRAL = 2;
    public static final int MIDDLE = 3;
    public static final int ALPHABETIC = 4;
    public static final int IDEOGRAPHIC = 5;
    private double[] baselines = new double[6];
    private int dominantBaseline;

    public double[] getBaselines() {
        return (double[])this.baselines.clone();
    }

    public void update(BaselineInfo parent) {
        System.arraycopy(parent.baselines, 0, this.baselines, 0, 6);
        this.dominantBaseline = parent.dominantBaseline;
    }

    public void setBaselines(double[] baselines) {
        if (baselines.length != 6) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(baselines, 0, this.baselines, 0, 6);
    }

    public double getBaseline(int indx) {
        return this.baselines[indx];
    }

    public void setBaseline(int idx, double baseline) {
        this.baselines[idx] = baseline;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public void setDominantBaseline(int dominantBaseline) {
        this.dominantBaseline = dominantBaseline;
    }
}

