/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.registry;

import java.util.TreeSet;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontRecord;

public class DefaultFontFamily
implements FontFamily {
    private TreeSet allNames;
    private String familyName;
    private FontRecord[] fontRecords;

    public DefaultFontFamily(String familyName) {
        if (familyName == null) {
            throw new NullPointerException("A FamilyName must be given");
        }
        this.familyName = familyName;
        this.allNames = new TreeSet();
        this.allNames.add(familyName);
        this.fontRecords = new FontRecord[4];
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void addName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        this.allNames.add(name);
    }

    public String[] getAllNames() {
        return this.allNames.toArray(new String[this.allNames.size()]);
    }

    public FontRecord getFontRecord(boolean bold, boolean italics) {
        FontRecord record;
        if (bold && italics && (record = this.fontRecords[3]) != null) {
            return record;
        }
        if (italics && (record = this.fontRecords[2]) != null) {
            return record;
        }
        if (bold && (record = this.fontRecords[1]) != null) {
            return record;
        }
        record = this.fontRecords[0];
        if (record != null) {
            return record;
        }
        for (int i = 0; i < this.fontRecords.length; ++i) {
            FontRecord fontRecord = this.fontRecords[i];
            if (fontRecord == null) continue;
            return fontRecord;
        }
        return null;
    }

    public void setFontRecord(FontRecord record) {
        boolean bold = record.isBold();
        boolean italics = record.isItalic();
        int index = bold && italics ? 3 : (italics ? 2 : (bold ? 1 : 0));
        FontRecord oldRecord = this.fontRecords[index];
        if (oldRecord == null) {
            this.fontRecords[index] = record;
        } else {
            if (record.isOblique() && !oldRecord.isOblique()) {
                return;
            }
            this.fontRecords[index] = record;
        }
    }
}

