/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.registry;

import java.util.HashMap;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontStorage;

public class DefaultFontStorage
implements FontStorage {
    private HashMap knownMetrics = new HashMap();
    private FontRegistry registry;
    private FontMetricsFactory metricsFactory;
    private FontKey lookupKey;

    public DefaultFontStorage(FontRegistry registry) {
        this.registry = registry;
        this.metricsFactory = registry.createMetricsFactory();
        this.lookupKey = new FontKey();
    }

    public FontRegistry getFontRegistry() {
        return this.registry;
    }

    public FontMetrics getFontMetrics(FontIdentifier record, FontContext context) {
        if (record == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        this.lookupKey.setAliased(context.isAntiAliased());
        this.lookupKey.setFontSize(context.getFontSize());
        this.lookupKey.setIdentifier(record);
        this.lookupKey.setFractional(context.isFractionalMetrics());
        FontMetrics cachedMetrics = (FontMetrics)this.knownMetrics.get(this.lookupKey);
        if (cachedMetrics != null) {
            return cachedMetrics;
        }
        FontKey key = new FontKey(record, context.isAntiAliased(), context.isFractionalMetrics(), context.getFontSize());
        FontMetrics metrics = this.metricsFactory.createMetrics(record, context);
        this.knownMetrics.put(key, metrics);
        return metrics;
    }

    private static class FontKey {
        private FontIdentifier identifier;
        private boolean aliased;
        private boolean fractional;
        private double fontSize;

        public FontKey(FontIdentifier identifier, boolean aliased, boolean fractional, double fontSize) {
            if (identifier == null) {
                throw new NullPointerException();
            }
            this.identifier = identifier;
            this.aliased = aliased;
            this.fractional = fractional;
            this.fontSize = fontSize;
        }

        public FontKey() {
        }

        public FontIdentifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(FontIdentifier identifier) {
            this.identifier = identifier;
        }

        public boolean isAliased() {
            return this.aliased;
        }

        public void setAliased(boolean aliased) {
            this.aliased = aliased;
        }

        public boolean isFractional() {
            return this.fractional;
        }

        public void setFractional(boolean fractional) {
            this.fractional = fractional;
        }

        public double getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(double fontSize) {
            this.fontSize = fontSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontKey fontKey = (FontKey)o;
            if (this.aliased != fontKey.aliased) {
                return false;
            }
            if (fontKey.fontSize != this.fontSize) {
                return false;
            }
            if (this.fractional != fontKey.fractional) {
                return false;
            }
            return ((Object)this.identifier).equals(fontKey.identifier);
        }

        public int hashCode() {
            int result = ((Object)this.identifier).hashCode();
            result = 29 * result + (this.aliased ? 1 : 0);
            result = 29 * result + (this.fractional ? 1 : 0);
            long temp = this.fontSize != 0.0 ? Double.doubleToLongBits(this.fontSize) : 0L;
            result = 29 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

