/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.registry;

import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontMetrics;

public class EmptyFontMetrics
implements FontMetrics {
    private double baseSize;
    private double baseWidth;

    public EmptyFontMetrics(double baseHeight, double baseWidth) {
        this.baseSize = baseHeight;
        this.baseWidth = baseWidth;
    }

    public EmptyFontMetrics() {
    }

    public double getAscent() {
        return this.baseSize * 0.7;
    }

    public double getDescent() {
        return this.baseSize * 0.3;
    }

    public double getLeading() {
        return 0.0;
    }

    public double getXHeight() {
        return this.baseSize * 0.5;
    }

    public double getOverlinePosition() {
        return 0.0;
    }

    public double getUnderlinePosition() {
        return this.getAscent();
    }

    public double getStrikeThroughPosition() {
        return this.getXHeight() * 0.5;
    }

    public double getMaxAscent() {
        return this.getAscent();
    }

    public double getMaxDescent() {
        return this.getDescent();
    }

    public double getMaxLeading() {
        return this.getLeading();
    }

    public double getMaxHeight() {
        return this.baseSize;
    }

    public double getMaxCharAdvance() {
        return this.baseWidth;
    }

    public double getCharWidth(int codePoint) {
        return this.baseWidth;
    }

    public double getKerning(int previous, int codePoint) {
        return 0.0;
    }

    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        if (info == null) {
            info = new BaselineInfo();
        }
        double maxAscent = this.getMaxAscent();
        info.setBaseline(1, maxAscent - this.getXHeight());
        info.setBaseline(5, this.getMaxHeight());
        info.setBaseline(3, maxAscent / 2.0);
        info.setBaseline(4, maxAscent);
        info.setBaseline(2, maxAscent / 2.0);
        info.setBaseline(0, maxAscent - this.getXHeight());
        info.setDominantBaseline(4);
        return info;
    }
}

